/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00108", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EmptyBlock_S00108_Check
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.BLOCK, JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS});
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS})) {
            if (!node.hasChildren()) {
                this.getContext().createLineViolation((CodeCheck)this, "Either remove or fill this block of code.", node.getParent(), new Object[0]);
            }
        } else if (node.getParent().isNot(new AstNodeType[]{JavaGrammar.METHOD_BODY}) && !EmptyBlock_S00108_Check.hasStatements(node) && !EmptyBlock_S00108_Check.hasCommentInside(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Either remove or fill this block of code.", node.getParent(), new Object[0]);
        }
    }

    private static boolean hasStatements(AstNode node) {
        return node.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS}).hasDirectChildren(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT});
    }

    private static boolean hasCommentInside(AstNode node) {
        return !node.getFirstChild(new AstNodeType[]{JavaPunctuator.RWING}).getToken().getTrivia().isEmpty();
    }
}

