/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1210", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class EqualsNotOverridenWithCompareToCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_BODY});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.ENUM_BODY_DECLARATIONS});
    }

    public void visitNode(AstNode node) {
        MethodHelper compareToMethod = null;
        boolean hasEquals = false;
        for (MethodHelper method : MethodHelper.getMethods((AstNode)node)) {
            if (method.getParameters().size() != 1) continue;
            if ("compareTo".equals(method.getName().getTokenOriginalValue())) {
                compareToMethod = method;
                continue;
            }
            if (!"equals".equals(method.getName().getTokenOriginalValue())) continue;
            hasEquals = true;
        }
        if (compareToMethod != null && !hasEquals) {
            this.getContext().createLineViolation((CodeCheck)this, "Override \"equals(Object obj)\" to comply with the contract of the \"compareTo(T o)\" method", compareToMethod.getName(), new Object[0]);
        }
    }
}

