/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1206", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class EqualsOverridenWithHashCodeCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String KEY = "S1206";
    private static final RuleKey RULE_KEY = RuleKey.of((String)"squid", (String)"S1206");
    private static final String HASHCODE = "hashCode";
    private static final String EQUALS = "equals";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        if (tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.ENUM) || tree.is(Tree.Kind.INTERFACE)) {
            MethodTree equalsMethod = null;
            MethodTree hashCodeMethod = null;
            for (Tree memberTree : tree.members()) {
                if (!memberTree.is(Tree.Kind.METHOD)) continue;
                MethodTree methodTree = (MethodTree)memberTree;
                if (EqualsOverridenWithHashCodeCheck.isEquals(methodTree)) {
                    equalsMethod = methodTree;
                    continue;
                }
                if (!EqualsOverridenWithHashCodeCheck.isHashCode(methodTree)) continue;
                hashCodeMethod = methodTree;
            }
            if (equalsMethod != null && hashCodeMethod == null) {
                this.context.addIssue(equalsMethod, RULE_KEY, EqualsOverridenWithHashCodeCheck.getMessage(EqualsOverridenWithHashCodeCheck.classTreeType(tree), EQUALS, HASHCODE));
            } else if (hashCodeMethod != null && equalsMethod == null) {
                this.context.addIssue(hashCodeMethod, RULE_KEY, EqualsOverridenWithHashCodeCheck.getMessage(EqualsOverridenWithHashCodeCheck.classTreeType(tree), HASHCODE, EQUALS));
            }
        }
    }

    private static boolean isEquals(MethodTree methodTree) {
        return EQUALS.equals(methodTree.simpleName().name()) && methodTree.parameters().size() == 1;
    }

    private static boolean isHashCode(MethodTree methodTree) {
        return HASHCODE.equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty();
    }

    private static String classTreeType(ClassTree tree) {
        String type;
        if (tree.is(Tree.Kind.CLASS)) {
            type = "class";
        } else if (tree.is(Tree.Kind.ENUM)) {
            type = "enum";
        } else if (tree.is(Tree.Kind.INTERFACE)) {
            type = "interface";
        } else {
            throw new IllegalStateException();
        }
        return type;
    }

    private static String getMessage(String type, String overridenMethod, String methodToOverride) {
        return "This " + type + " overrides \"" + overridenMethod + "()\" and should therefore also override \"" + methodToOverride + "()\".";
    }
}

