/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ForLoopCounterChangedCheck", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ForLoopCounterChangedCheck
extends SquidCheck<LexerlessGrammar> {
    private Set<String> pendingLoopCounters = Collections.emptySet();
    private final Set<String> loopCounters = Sets.newHashSet();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.FOR_STATEMENT});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.ASSIGNMENT_EXPRESSION});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION_NOT_PLUS_MINUS});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.STATEMENT});
    }

    public void visitFile(AstNode astNode) {
        this.loopCounters.clear();
    }

    public void visitNode(AstNode node) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!node.is(new AstNodeType[]{JavaGrammar.FOR_STATEMENT})) break block2;
                        this.pendingLoopCounters = this.getLoopCounters(node);
                        break block3;
                    }
                    if (!node.is(new AstNodeType[]{JavaGrammar.STATEMENT}) || !node.getParent().is(new AstNodeType[]{JavaGrammar.FOR_STATEMENT})) break block4;
                    this.loopCounters.addAll(this.pendingLoopCounters);
                    this.pendingLoopCounters = Collections.emptySet();
                    break block3;
                }
                if (this.loopCounters.isEmpty()) break block3;
                if (!node.is(new AstNodeType[]{JavaGrammar.ASSIGNMENT_EXPRESSION})) break block5;
                for (int i = 0; i < node.getNumberOfChildren() - 1; ++i) {
                    this.check(ForLoopCounterChangedCheck.merge(node.getChild(i)), node.getChild(i).getTokenLine());
                }
                break block3;
            }
            if (!ForLoopCounterChangedCheck.isIncrementOrDecrementExpression(node)) break block3;
            for (AstNode child : node.getChildren()) {
                this.check(ForLoopCounterChangedCheck.merge(child), child.getTokenLine());
            }
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.FOR_STATEMENT})) {
            this.loopCounters.removeAll(this.getLoopCounters(node));
        }
    }

    private static boolean isIncrementOrDecrementExpression(AstNode node) {
        return node.is(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION, JavaGrammar.UNARY_EXPRESSION_NOT_PLUS_MINUS}) && node.select().children(new AstNodeType[]{JavaGrammar.PREFIX_OP, JavaGrammar.POST_FIX_OP}).children(new AstNodeType[]{JavaPunctuator.INC, JavaPunctuator.DEC}).isNotEmpty();
    }

    private Set<String> getLoopCounters(AstNode node) {
        ImmutableSet result;
        AstSelect identifiers = node.select().children((AstNodeType)JavaGrammar.FOR_INIT).children((AstNodeType)JavaGrammar.VARIABLE_DECLARATORS).children((AstNodeType)JavaGrammar.VARIABLE_DECLARATOR).children((AstNodeType)JavaTokenType.IDENTIFIER);
        if (identifiers.isNotEmpty()) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AstNode identifier : identifiers) {
                builder.add((Object)identifier.getTokenOriginalValue());
            }
            result = builder.build();
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private void check(String string, int line) {
        if (this.loopCounters.contains(string)) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor the code in order to not assign to this loop counter from within the loop body.", line, new Object[0]);
        }
    }

    private static String merge(AstNode node) {
        StringBuilder sb = new StringBuilder();
        for (Token token : node.getTokens()) {
            sb.append(token.getOriginalValue());
        }
        return sb.toString();
    }
}

