/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S881", priority=Priority.MAJOR)
public class IncrementDecrementInSubExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S881";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S881");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expressionTree = tree.expression();
        if (IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement((Tree)expressionTree)) {
            UnaryExpressionTree unaryExpressionTree = (UnaryExpressionTree)expressionTree;
            expressionTree = unaryExpressionTree.expression();
        }
        this.scan((Tree)expressionTree);
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        if (IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement((Tree)tree)) {
            this.context.addIssue((Tree)tree, RULE, "Extract this increment or decrement operator into a dedicated statement.");
        }
    }

    private static boolean isIncrementOrDecrement(Tree tree) {
        return tree.is(Tree.Kind.PREFIX_INCREMENT) || tree.is(Tree.Kind.PREFIX_DECREMENT) || tree.is(Tree.Kind.POSTFIX_INCREMENT) || tree.is(Tree.Kind.POSTFIX_DECREMENT);
    }
}

