/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Rule(key="RedundantThrowsDeclarationCheck", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class RedundantThrowsDeclarationCheck
extends BytecodeVisitor {
    public static final String RULE_KEY = "RedundantThrowsDeclarationCheck";
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
        if (sourceMethod != null) {
            HashSet reportedExceptions = Sets.newHashSet();
            List thrownClasses = asmMethod.getThrows();
            for (AsmClass thrownClass : thrownClasses) {
                String thrownClassName = thrownClass.getDisplayName();
                if (reportedExceptions.contains(thrownClassName)) continue;
                String issueMessage = null;
                if (RedundantThrowsDeclarationCheck.isSubClassOfAny(thrownClass, thrownClasses)) {
                    issueMessage = "Remove the declaration of thrown exception '" + thrownClassName + "' which is a subclass of another one.";
                } else if (RedundantThrowsDeclarationCheck.isSubClassOfRuntimeException(thrownClass)) {
                    issueMessage = "Remove the declaration of thrown exception '" + thrownClassName + "' which is a runtime exception.";
                } else if (RedundantThrowsDeclarationCheck.isDeclaredMoreThanOnce(thrownClass, thrownClasses)) {
                    issueMessage = "Remove the redundant '" + thrownClassName + "' thrown exception declaration(s).";
                }
                if (issueMessage == null) continue;
                reportedExceptions.add(thrownClassName);
                CheckMessage message = new CheckMessage((Object)this, issueMessage, new Object[0]);
                message.setLine(sourceMethod.getStartAtLine());
                SourceFile file = this.getSourceFile(this.asmClass);
                file.log(message);
            }
        }
    }

    private static boolean isDeclaredMoreThanOnce(AsmClass thrownClass, List<AsmClass> thrownClassCandidates) {
        int matches = 0;
        for (AsmClass thrownClassCandidate : thrownClassCandidates) {
            if (!thrownClass.equals((Object)thrownClassCandidate)) continue;
            ++matches;
        }
        return matches > 1;
    }

    private static boolean isSubClassOfAny(AsmClass thrownClass, List<AsmClass> thrownClassCandidates) {
        for (AsmClass current = thrownClass.getSuperClass(); current != null; current = current.getSuperClass()) {
            for (AsmClass thrownClassCandidate : thrownClassCandidates) {
                if (!current.equals((Object)thrownClassCandidate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSubClassOfRuntimeException(AsmClass thrownClass) {
        for (AsmClass current = thrownClass; current != null; current = current.getSuperClass()) {
            if (!"java/lang/RuntimeException".equals(current.getInternalName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RedundantThrowsDeclarationCheck rule";
    }
}

