/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoOverallSensor
implements Sensor {
    public static final String JACOCO_OVERALL = "jacoco-overall.exec";
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final ModuleFileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;

    public JaCoCoOverallSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, ModuleFileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
    }

    public boolean shouldExecuteOnProject(Project project) {
        File reportUTs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        File reportITs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        boolean foundBothReports = reportUTs.exists() && reportITs.exists();
        boolean shouldExecute = this.configuration.shouldExecuteOnProject(foundBothReports);
        if (!foundBothReports && shouldExecute) {
            JaCoCoExtensions.LOG.info("JaCoCoOverallSensor: JaCoCo reports not found.");
        }
        return shouldExecute;
    }

    public void analyse(Project project, SensorContext context) {
        File reportUTs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        File reportITs = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getItReportPath());
        if (!reportUTs.exists() || !reportITs.exists()) {
            return;
        }
        File reportOverall = new File(this.fileSystem.workingDir(), JACOCO_OVERALL);
        reportOverall.getParentFile().mkdirs();
        this.mergeReports(reportOverall, reportUTs, reportITs);
        new OverallAnalyzer(reportOverall, this.perspectives).analyse(project, context);
    }

    private void mergeReports(File reportOverall, File ... reports) {
        SessionInfoStore infoStore = new SessionInfoStore();
        ExecutionDataStore dataStore = new ExecutionDataStore();
        this.loadSourceFiles(infoStore, dataStore, reports);
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(reportOverall));
            ExecutionDataWriter dataWriter = new ExecutionDataWriter((OutputStream)outputStream);
            infoStore.accept((ISessionInfoVisitor)dataWriter);
            dataStore.accept((IExecutionDataVisitor)dataWriter);
        }
        catch (IOException e) {
            try {
                throw new SonarException(String.format("Unable to write overall coverage report %s", reportOverall.getAbsolutePath()), (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(outputStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)outputStream);
    }

    private void loadSourceFiles(SessionInfoStore infoStore, ExecutionDataStore dataStore, File ... reports) {
        for (File report : reports) {
            BufferedInputStream resourceStream = null;
            try {
                resourceStream = new BufferedInputStream(new FileInputStream(report));
                ExecutionDataReader reader = new ExecutionDataReader((InputStream)resourceStream);
                reader.setSessionInfoVisitor((ISessionInfoVisitor)infoStore);
                reader.setExecutionDataVisitor((IExecutionDataVisitor)dataStore);
                reader.read();
            }
            catch (IOException e) {
                try {
                    throw new SonarException(String.format("Unable to read %s", report.getAbsolutePath()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(resourceStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)resourceStream);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class OverallAnalyzer
    extends AbstractAnalyzer {
        private final File report;

        OverallAnalyzer(File report, ResourcePerspectives perspectives) {
            super(perspectives, JaCoCoOverallSensor.this.fileSystem, JaCoCoOverallSensor.this.pathResolver, JaCoCoOverallSensor.this.javaResourceLocator);
            this.report = report;
        }

        @Override
        protected String getReportPath(Project project) {
            return this.report.getAbsolutePath();
        }

        @Override
        protected void saveMeasures(SensorContext context, Resource resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                Measure mergedMeasure = this.convertForOverall(measure);
                if (mergedMeasure == null) continue;
                context.saveMeasure(resource, mergedMeasure);
            }
        }

        private Measure convertForOverall(Measure measure) {
            Measure itMeasure = null;
            if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_LINES_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_LINES, measure.getValue());
            } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, measure.getData());
            } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_TO_COVER, measure.getValue());
            } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, measure.getValue());
            } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE, measure.getData());
            } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
                itMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_BY_LINE, measure.getData());
            }
            return itMeasure;
        }
    }
}

