/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.ast.AstScanner;
import org.sonar.java.ast.api.JavaGrammar;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.ast.visitors.AccessorVisitor;
import org.sonar.java.ast.visitors.AnonymousInnerClassVisitor;
import org.sonar.java.ast.visitors.ClassVisitor;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.ast.visitors.EndAtLineVisitor;
import org.sonar.java.ast.visitors.FileVisitor;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.java.ast.visitors.LinesVisitor;
import org.sonar.java.ast.visitors.MethodVisitor;
import org.sonar.java.ast.visitors.PackageVisitor;
import org.sonar.java.ast.visitors.PublicApiVisitor;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaAstScanner {
    private JavaAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<JavaGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner scanner = JavaAstScanner.create(new JavaConfiguration(Charset.forName("UTF-8")), visitors);
        InputFile inputFile = InputFileUtils.create((File)file.getParentFile(), (File)file);
        scanner.scan(Collections.singleton(inputFile));
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner create(JavaConfiguration conf, SquidAstVisitor<JavaGrammar> ... visitors) {
        Parser<JavaGrammar> parser = JavaParser.create(conf, new ParsingEventListener[0]);
        AstScanner builder = new AstScanner(parser);
        builder.withSquidAstVisitor(new PackageVisitor());
        builder.withSquidAstVisitor(new FileVisitor());
        builder.withSquidAstVisitor(new ClassVisitor());
        builder.withSquidAstVisitor(new AnonymousInnerClassVisitor());
        builder.withSquidAstVisitor(new MethodVisitor());
        if (conf.isAnalysePropertyAccessors()) {
            builder.withSquidAstVisitor(new AccessorVisitor());
        }
        builder.withSquidAstVisitor(new PublicApiVisitor());
        builder.withSquidAstVisitor(new EndAtLineVisitor());
        builder.setCommentAnalyser(new CommentAnalyser(){

            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    char character = line.charAt(i);
                    if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
                    return false;
                }
                return true;
            }

            public String getContents(String comment) {
                return comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
            }
        });
        builder.withSquidAstVisitor(new LinesVisitor(conf.getCharset()));
        builder.withSquidAstVisitor(new LinesOfCodeVisitor());
        builder.withSquidAstVisitor(new CommentLinesVisitor());
        builder.withSquidAstVisitor((SquidAstVisitor<JavaGrammar>)CommentsVisitor.builder().withBlankCommentMetric((MetricDef)JavaMetric.COMMENT_BLANK_LINES).withNoSonar(true).withIgnoreHeaderComment(true).build());
        builder.withSquidAstVisitor((SquidAstVisitor<JavaGrammar>)CounterVisitor.builder().setMetricDef((MetricDef)JavaMetric.STATEMENTS).subscribeTo(new AstNodeType[]{((JavaGrammar)parser.getGrammar()).localVariableDeclarationStatement, ((JavaGrammar)parser.getGrammar()).assertStatement, ((JavaGrammar)parser.getGrammar()).ifStatement, ((JavaGrammar)parser.getGrammar()).forStatement, ((JavaGrammar)parser.getGrammar()).whileStatement, ((JavaGrammar)parser.getGrammar()).doStatement, ((JavaGrammar)parser.getGrammar()).tryStatement, ((JavaGrammar)parser.getGrammar()).switchStatement, ((JavaGrammar)parser.getGrammar()).synchronizedStatement, ((JavaGrammar)parser.getGrammar()).returnStatement, ((JavaGrammar)parser.getGrammar()).throwStatement, ((JavaGrammar)parser.getGrammar()).breakStatement, ((JavaGrammar)parser.getGrammar()).continueStatement, ((JavaGrammar)parser.getGrammar()).expressionStatement, ((JavaGrammar)parser.getGrammar()).emptyStatement}).build());
        builder.withSquidAstVisitor(new ComplexityVisitor());
        for (SquidAstVisitor<JavaGrammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder;
    }
}

