/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.lexer;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.Map;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIdentifierAndKeywordChannel
extends Channel<Lexer> {
    private final Map<String, TokenType> keywordsMap;
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Token.Builder tokenBuilder = Token.builder();

    public JavaIdentifierAndKeywordChannel(TokenType[] ... keywordSets) {
        ImmutableMap.Builder keywordsMapBuilder = ImmutableMap.builder();
        TokenType[][] arr$ = keywordSets;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TokenType[] keywords;
            for (TokenType keyword : keywords = arr$[i$]) {
                keywordsMapBuilder.put((Object)keyword.getValue(), (Object)keyword);
            }
        }
        this.keywordsMap = keywordsMapBuilder.build();
    }

    public boolean consume(CodeReader code, Lexer lexer) {
        if (!Character.isJavaIdentifierStart(code.peek())) {
            return false;
        }
        int line = code.getCursor().getLine();
        int column = code.getCursor().getColumn();
        while (Character.isJavaIdentifierPart(code.peek())) {
            this.tmpBuilder.append((char)code.pop());
        }
        String word = this.tmpBuilder.toString();
        TokenType keywordType = this.keywordsMap.get(word);
        Token token = this.tokenBuilder.setType((TokenType)(keywordType == null ? GenericTokenType.IDENTIFIER : keywordType)).setValueAndOriginalValue(word, word).setURI(lexer.getURI()).setLine(line).setColumn(column).build();
        lexer.addToken(new Token[]{token});
        this.tmpBuilder.delete(0, this.tmpBuilder.length());
        return true;
    }
}

