/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannel;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import java.nio.charset.Charset;
import org.sonar.channel.Channel;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.lexer.CharStartChannel;
import org.sonar.java.ast.lexer.CharacterLiteralChannel;
import org.sonar.java.ast.lexer.DigitStartChannel;
import org.sonar.java.ast.lexer.InlineCommentChannel;
import org.sonar.java.ast.lexer.JavaIdentifierAndKeywordChannel;
import org.sonar.java.ast.lexer.MultilineCommentChannel;
import org.sonar.java.ast.lexer.WhitespaceChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP = "([Pp][+-]?+[0-9_]++)";
    private static final String FLOAT_SUFFIX = "[fFdD]";
    private static final String INT_SUFFIX = "[lL]";

    private JavaLexer() {
    }

    public static Lexer create(Charset charset) {
        Lexer.Builder builder = Lexer.builder().withCharset(charset).withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)new WhitespaceChannel()).withChannel((Channel)new InlineCommentChannel()).withChannel((Channel)new MultilineCommentChannel()).withChannel((Channel)new CharacterLiteralChannel('\"', (TokenType)GenericTokenType.LITERAL)).withChannel((Channel)new CharacterLiteralChannel('\'', JavaTokenType.CHARACTER_LITERAL)).withChannel(JavaLexer.digitStart((Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.FLOATING_LITERAL, "[0-9_]++\\.([0-9_]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+"))).withChannel(JavaLexer.start('.', (Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.FLOATING_LITERAL, "\\.[0-9][0-9_]*+([Ee][+-]?+[0-9_]++)?+[fFdD]?+"))).withChannel(JavaLexer.digitStart((Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.FLOATING_LITERAL, "[0-9_]++[fFdD]"))).withChannel(JavaLexer.digitStart((Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.FLOATING_LITERAL, "[0-9_]++([Ee][+-]?+[0-9_]++)[fFdD]?+"))).withChannel(JavaLexer.start('0', (Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.FLOATING_LITERAL, "0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+"))).withChannel(JavaLexer.start('0', (Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.FLOATING_LITERAL, "0[xX][0-9_a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+"))).withChannel(JavaLexer.start('0', (Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.INTEGER_LITERAL, "0[xX][0-9_a-fA-F]++[lL]?+"))).withChannel(JavaLexer.start('0', (Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.INTEGER_LITERAL, "0[bB][01_]++[lL]?+"))).withChannel(JavaLexer.digitStart((Channel<Lexer>)new RegexpChannel((TokenType)JavaTokenType.INTEGER_LITERAL, "[0-9_]++[lL]?+"))).withChannel((Channel)new JavaIdentifierAndKeywordChannel(new TokenType[][]{JavaKeyword.values()})).withChannel((Channel)new PunctuatorChannel((TokenType[])JavaPunctuator.values())).withChannel((Channel)new UnknownCharacterChannel(true));
        return builder.build();
    }

    private static Channel<Lexer> digitStart(Channel<Lexer> channel) {
        return new DigitStartChannel(channel);
    }

    private static Channel<Lexer> start(char ch, Channel<Lexer> channel) {
        return new CharStartChannel(ch, channel);
    }
}

