/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Lexer;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilineCommentChannel
extends Channel<Lexer> {
    private final StringBuilder sb = new StringBuilder();
    private final Token.Builder tokenBuilder = Token.builder();

    public boolean consume(CodeReader code, Lexer lexer) {
        int prev;
        if (code.charAt(0) != '/' || code.charAt(1) != '*') {
            return false;
        }
        int column = code.getCursor().getColumn();
        int line = code.getCursor().getLine();
        this.sb.append((char)code.pop());
        this.sb.append((char)code.pop());
        do {
            prev = code.pop();
            this.sb.append((char)prev);
        } while (prev != 42 || code.peek() != 47);
        this.sb.append((char)code.pop());
        String value = this.sb.toString();
        Token token = this.tokenBuilder.setType((TokenType)GenericTokenType.COMMENT).setValueAndOriginalValue(value).setURI(lexer.getURI()).setLine(line).setColumn(column).build();
        lexer.addTrivia(new Trivia[]{Trivia.createComment((Token)token)});
        this.sb.delete(0, this.sb.length());
        return true;
    }
}

