/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.java.ast.api.JavaGrammar;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squid.measures.MetricDef;

public class ComplexityVisitor
extends JavaAstVisitor {
    public void init() {
        JavaGrammar grammar = (JavaGrammar)this.getContext().getGrammar();
        this.subscribeTo(new AstNodeType[]{grammar.methodBody, grammar.ifStatement, grammar.forStatement, grammar.whileStatement, grammar.doStatement, JavaKeyword.CASE, grammar.returnStatement, grammar.throwStatement, grammar.catchClause, grammar.conditionalExpression, JavaPunctuator.ANDAND, JavaPunctuator.OROR});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).returnStatement}) && this.isLastReturnStatement(astNode)) {
            return;
        }
        this.getContext().peekSourceCode().add((MetricDef)JavaMetric.COMPLEXITY, 1.0);
    }

    private boolean isLastReturnStatement(AstNode astNode) {
        AstNode parent = astNode.getParent().getParent().getParent();
        AstNode block = astNode.findFirstParent((AstNodeType)((JavaGrammar)this.getContext().getGrammar()).blockStatements);
        return block.getParent().getParent().is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).methodBody}) && parent == block;
    }
}

