/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.squid.SquidAstVisitor;
import java.util.Collections;
import java.util.List;
import org.sonar.java.ast.api.JavaGrammar;
import org.sonar.java.ast.api.JavaKeyword;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHelper {
    private final JavaGrammar grammar;
    private final AstNode astNode;

    public MethodHelper(JavaGrammar grammar, AstNode astNode) {
        this.grammar = grammar;
        this.astNode = astNode;
    }

    public static void subscribe(SquidAstVisitor<JavaGrammar> visitor) {
        JavaGrammar grammar = (JavaGrammar)visitor.getContext().getGrammar();
        visitor.subscribeTo(new AstNodeType[]{grammar.methodDeclaratorRest, grammar.voidMethodDeclaratorRest, grammar.constructorDeclaratorRest, grammar.interfaceMethodDeclaratorRest, grammar.voidInterfaceMethodDeclaratorsRest, grammar.annotationMethodRest});
    }

    public boolean isPublic() {
        AstNode node;
        if (this.astNode.is(new AstNodeType[]{this.grammar.methodDeclaratorRest, this.grammar.voidMethodDeclaratorRest, this.grammar.constructorDeclaratorRest})) {
            node = this.astNode.findFirstParent((AstNodeType)this.grammar.classBodyDeclaration);
        } else if (this.astNode.is(new AstNodeType[]{this.grammar.interfaceMethodDeclaratorRest, this.grammar.voidInterfaceMethodDeclaratorsRest})) {
            node = this.astNode.findFirstParent((AstNodeType)this.grammar.interfaceBodyDeclaration);
        } else if (this.astNode.is(new AstNodeType[]{this.grammar.annotationMethodRest})) {
            node = this.astNode.findFirstParent((AstNodeType)this.grammar.annotationTypeElementDeclaration);
        } else {
            throw new IllegalStateException();
        }
        for (AstNode modifierNode : node.findDirectChildren(new AstNodeType[]{this.grammar.modifier})) {
            if (!modifierNode.getChild(0).is(new AstNodeType[]{JavaKeyword.PUBLIC})) continue;
            return true;
        }
        return false;
    }

    public boolean isConstructor() {
        return this.astNode.is(new AstNodeType[]{this.grammar.constructorDeclaratorRest});
    }

    public AstNode getReturnType() {
        AstNode typeNode = this.getName().previousAstNode();
        Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaKeyword.VOID, this.grammar.type}));
        return typeNode;
    }

    public AstNode getName() {
        AstNode methodNameNode = this.astNode.is(new AstNodeType[]{this.grammar.interfaceMethodDeclaratorRest}) ? this.astNode.previousAstNode() : (this.astNode.is(new AstNodeType[]{this.grammar.annotationMethodRest}) ? this.astNode.getChild(0) : this.astNode.previousSibling());
        Preconditions.checkState((boolean)methodNameNode.is(new AstNodeType[]{GenericTokenType.IDENTIFIER}));
        return methodNameNode;
    }

    public List<AstNode> getParameters() {
        AstNode node = this.astNode.findFirstDirectChild(new AstNodeType[]{this.grammar.formalParameters});
        if (node == null) {
            return Collections.emptyList();
        }
        return node.findChildren(new AstNodeType[]{this.grammar.formalParameterDecls});
    }

    public boolean hasParameters() {
        return this.getParameters().size() > 0;
    }

    public List<AstNode> getStatements() {
        AstNode node = this.astNode.findFirstDirectChild(new AstNodeType[]{this.grammar.methodBody});
        if (node == null) {
            return Collections.emptyList();
        }
        return node.findFirstChild(new AstNodeType[]{this.grammar.blockStatements}).getChildren();
    }
}

