/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.api.JavaGrammar;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.java.ast.visitors.PublicApiVisitor;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.MethodSignature;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.Parameter;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodVisitor
extends JavaAstVisitor {
    private static final Map<JavaKeyword, JvmJavaType> JAVA_TYPE_MAPPING = Maps.newHashMap();

    public void init() {
        MethodHelper.subscribe(this);
    }

    public void visitNode(AstNode astNode) {
        String methodName = this.buildMethodSignature(new MethodHelper((JavaGrammar)this.getContext().getGrammar(), astNode));
        SourceClass sourceClass = this.peekSourceClass();
        int startLine = PublicApiVisitor.getDeclaration((JavaGrammar)this.getContext().getGrammar(), astNode).getTokenLine();
        SourceMethod sourceMethod = new SourceMethod(sourceClass, methodName, startLine);
        sourceMethod.setMeasure((MetricDef)JavaMetric.METHODS, 1);
        this.getContext().addSourceCode((SourceCode)sourceMethod);
    }

    public void leaveNode(AstNode astNode) {
        this.getContext().popSourceCode();
    }

    private String buildMethodSignature(MethodHelper methodHelper) {
        String methodName = this.extractMethodName(methodHelper);
        Parameter returnType = this.extractMethodReturnType(methodHelper);
        List<Parameter> argumentTypes = this.extractMethodArgumentTypes(methodHelper);
        MethodSignature signature = new MethodSignature(methodName, returnType, argumentTypes);
        return MethodSignaturePrinter.print(signature);
    }

    private String extractMethodName(MethodHelper methodHelper) {
        if (methodHelper.isConstructor()) {
            return "<init>";
        }
        return methodHelper.getName().getTokenValue();
    }

    private Parameter extractMethodReturnType(MethodHelper methodHelper) {
        if (methodHelper.isConstructor()) {
            return new Parameter(JvmJavaType.V, false);
        }
        AstNode returnType = methodHelper.getReturnType();
        boolean isArray = returnType.hasDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).dim});
        return new Parameter(this.extractArgumentAndReturnType(returnType, isArray));
    }

    private List<Parameter> extractMethodArgumentTypes(MethodHelper methodHelper) {
        ArrayList argumentTypes = Lists.newArrayList();
        for (AstNode astNode : methodHelper.getParameters()) {
            AstNode type = astNode.findFirstDirectChild(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).type});
            boolean isArray = type.hasDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).dim}) || astNode.findFirstChild(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).variableDeclaratorId}).hasDirectChildren(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).dim});
            argumentTypes.add(this.extractArgumentAndReturnType(type, isArray));
        }
        return argumentTypes;
    }

    private Parameter extractArgumentAndReturnType(AstNode astNode, boolean isArray) {
        Preconditions.checkArgument((boolean)astNode.is(new AstNodeType[]{JavaKeyword.VOID, ((JavaGrammar)this.getContext().getGrammar()).type}));
        if (astNode.is(new AstNodeType[]{JavaKeyword.VOID})) {
            return new Parameter(JvmJavaType.V, false);
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).basicType})) {
            return new Parameter(JAVA_TYPE_MAPPING.get(astNode.getFirstChild().getFirstChild().getType()), isArray);
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).classType})) {
            return new Parameter(this.extractClassName(astNode.getFirstChild()), isArray);
        }
        throw new IllegalStateException();
    }

    private String extractClassName(AstNode astNode) {
        Preconditions.checkArgument((boolean)astNode.is(new AstNodeType[]{((JavaGrammar)this.getContext().getGrammar()).classType}));
        return ((AstNode)Iterables.getLast((Iterable)astNode.findDirectChildren(new AstNodeType[]{GenericTokenType.IDENTIFIER}))).getTokenValue();
    }

    static {
        JAVA_TYPE_MAPPING.put(JavaKeyword.BYTE, JvmJavaType.B);
        JAVA_TYPE_MAPPING.put(JavaKeyword.CHAR, JvmJavaType.C);
        JAVA_TYPE_MAPPING.put(JavaKeyword.SHORT, JvmJavaType.S);
        JAVA_TYPE_MAPPING.put(JavaKeyword.INT, JvmJavaType.I);
        JAVA_TYPE_MAPPING.put(JavaKeyword.LONG, JvmJavaType.J);
        JAVA_TYPE_MAPPING.put(JavaKeyword.BOOLEAN, JvmJavaType.Z);
        JAVA_TYPE_MAPPING.put(JavaKeyword.FLOAT, JvmJavaType.F);
        JAVA_TYPE_MAPPING.put(JavaKeyword.DOUBLE, JvmJavaType.D);
        JAVA_TYPE_MAPPING.put(JavaKeyword.VOID, JvmJavaType.V);
    }
}

