/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.squid.api.SourceCodeEdgeUsage;

public class AsmEdge {
    private final AsmResource from;
    private final AsmResource to;
    private final SourceCodeEdgeUsage usage;
    private int sourceLineNumber = 0;

    AsmEdge(AsmResource from, AsmResource to, SourceCodeEdgeUsage usage) {
        this.from = from;
        this.to = to;
        this.usage = usage;
        to.setUsed(true);
    }

    AsmEdge(AsmResource from, AsmResource to, SourceCodeEdgeUsage usage, int sourceLineNumber) {
        this(from, to, usage);
        this.sourceLineNumber = sourceLineNumber;
    }

    public int getSourceLineNumber() {
        return this.sourceLineNumber;
    }

    public AsmClass getTargetAsmClass() {
        if (this.getTo().getParent() != null) {
            return this.getTo().getParent();
        }
        return (AsmClass)this.getTo();
    }

    public AsmResource getFrom() {
        return this.from;
    }

    public AsmResource getTo() {
        return this.to;
    }

    public SourceCodeEdgeUsage getUsage() {
        return this.usage;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AsmEdge)) {
            return false;
        }
        AsmEdge edge = (AsmEdge)obj;
        return this.from.equals(edge.from) && this.to.equals(edge.to);
    }

    public int hashCode() {
        return this.from.hashCode() + this.to.hashCode() + this.usage.hashCode();
    }
}

