/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Resource;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.SemanticModel;

public class SymbolTableVisitor
extends JavaAstVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolTableVisitor.class);
    private final ResourcePerspectives perspectives;

    public SymbolTableVisitor(ResourcePerspectives perspectives) {
        this.perspectives = perspectives;
    }

    public void visitFile(AstNode astNode) {
        SemanticModel semanticModel;
        if (astNode == null) {
            return;
        }
        try {
            semanticModel = SemanticModel.createFor(astNode);
        }
        catch (Exception e) {
            LOG.error("Unable to create symbol table for " + this.getContext().getFile(), (Throwable)e);
            return;
        }
        JavaFile sonarFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)this.peekSourceFile().getKey());
        Symbolizable symbolizable = (Symbolizable)this.perspectives.as(Symbolizable.class, (Resource)sonarFile);
        Symbolizable.SymbolTableBuilder symbolTableBuilder = symbolizable.newSymbolTableBuilder();
        for (Map.Entry<AstNode, org.sonar.java.resolve.Symbol> entry : semanticModel.getSymbols().entrySet()) {
            AstNode declaration = entry.getKey();
            Symbol symbol = symbolTableBuilder.newSymbol(SymbolTableVisitor.startOffsetFor(declaration), SymbolTableVisitor.endOffsetFor(declaration));
            for (AstNode usage : semanticModel.getUsages(entry.getValue())) {
                symbolTableBuilder.newReference(symbol, SymbolTableVisitor.startOffsetFor(usage));
            }
        }
        symbolizable.setSymbolTable(symbolTableBuilder.build());
    }

    private static int startOffsetFor(AstNode astNode) {
        return astNode.getFromIndex();
    }

    private static int endOffsetFor(AstNode astNode) {
        return astNode.getFromIndex() + astNode.getTokenValue().length();
    }
}

