/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Resource;
import org.sonar.api.source.Highlightable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;

public class SyntaxHighlighterVisitor
extends JavaAstVisitor
implements AstAndTokenVisitor {
    private final ResourcePerspectives perspectives;
    private final Map<AstNodeType, String> types;
    private final Charset charset;
    private Highlightable.HighlightingBuilder highlighting;
    private List<Integer> lineStart;

    public SyntaxHighlighterVisitor(ResourcePerspectives perspectives, Charset charset) {
        this.charset = charset;
        this.perspectives = perspectives;
        ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
        for (JavaKeyword type : JavaKeyword.values()) {
            typesBuilder.put((Object)type, (Object)"k");
        }
        typesBuilder.put((Object)JavaTokenType.CHARACTER_LITERAL, (Object)"s");
        typesBuilder.put((Object)JavaTokenType.LITERAL, (Object)"s");
        typesBuilder.put((Object)JavaTokenType.FLOAT_LITERAL, (Object)"c");
        typesBuilder.put((Object)JavaTokenType.DOUBLE_LITERAL, (Object)"c");
        typesBuilder.put((Object)JavaTokenType.LONG_LITERAL, (Object)"c");
        typesBuilder.put((Object)JavaTokenType.INTEGER_LITERAL, (Object)"c");
        typesBuilder.put((Object)JavaGrammar.ANNOTATION, (Object)"a");
        this.types = typesBuilder.build();
    }

    public void init() {
        for (AstNodeType type : this.types.keySet()) {
            this.subscribeTo(new AstNodeType[]{type});
        }
    }

    public void visitFile(AstNode astNode) {
        String content;
        if (astNode == null) {
            return;
        }
        JavaFile sonarFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)this.peekSourceFile().getKey());
        this.highlighting = ((Highlightable)this.perspectives.as(Highlightable.class, (Resource)sonarFile)).newHighlighting();
        this.lineStart = Lists.newArrayList();
        try {
            content = Files.toString((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.lineStart.add(0);
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) != '\n' && (content.charAt(i) != '\r' || i + 1 >= content.length() || content.charAt(i + 1) == '\n')) continue;
            this.lineStart.add(i + 1);
        }
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
            this.highlighting.highlight(astNode.getFromIndex(), astNode.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}).getToIndex(), this.types.get(astNode.getType()));
        } else {
            this.highlighting.highlight(astNode.getFromIndex(), astNode.getToIndex(), this.types.get(astNode.getType()));
        }
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            Token triviaToken = trivia.getToken();
            int offset = this.getOffset(triviaToken.getLine(), triviaToken.getColumn());
            this.highlighting.highlight(offset, offset + triviaToken.getValue().length(), "cppd");
        }
    }

    private int getOffset(int line, int column) {
        return this.lineStart.get(line - 1) + column;
    }

    public void leaveFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        this.highlighting.done();
    }
}

