/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.java.bytecode.asm.AsmAccessFlags;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.squid.api.SourceCodeEdgeUsage;

public class AsmResource {
    private int accessFlags;
    AsmClass parent;
    boolean used = false;
    private List<AsmEdge> outgoingEdges = new ArrayList<AsmEdge>();

    void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    void addUsesOfClasses(AsmClass[] asmClasses) {
        for (AsmClass asmClass : asmClasses) {
            this.addEdge(new AsmEdge(this, asmClass, SourceCodeEdgeUsage.USES));
        }
    }

    public Set<AsmClass> getDistinctUsedAsmClasses() {
        HashSet<AsmClass> distinctUsedAsmClasses = new HashSet<AsmClass>();
        for (AsmEdge usage : this.getOutgoingEdges()) {
            if (usage.getUsage() != SourceCodeEdgeUsage.USES) continue;
            distinctUsedAsmClasses.add((AsmClass)usage.getTo());
        }
        return distinctUsedAsmClasses;
    }

    public Set<AsmClass> getImplementedInterfaces() {
        HashSet<AsmClass> implementedInterfaces = new HashSet<AsmClass>();
        for (AsmEdge usage : this.getOutgoingEdges()) {
            if (usage.getUsage() != SourceCodeEdgeUsage.IMPLEMENTS) continue;
            implementedInterfaces.add((AsmClass)usage.getTo());
        }
        return implementedInterfaces;
    }

    public void addEdge(AsmEdge edge) {
        this.outgoingEdges.add(edge);
    }

    public Collection<AsmEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public AsmClass getParent() {
        return this.parent;
    }

    public boolean isAbstract() {
        return AsmAccessFlags.isAbstract(this.accessFlags);
    }

    public boolean isInterface() {
        return AsmAccessFlags.isInterface(this.accessFlags);
    }

    public boolean isStatic() {
        return AsmAccessFlags.isStatic(this.accessFlags);
    }

    boolean isPublic() {
        return AsmAccessFlags.isPublic(this.accessFlags);
    }

    public boolean isPrivate() {
        return AsmAccessFlags.isPrivate(this.accessFlags);
    }

    public boolean isProtected() {
        return AsmAccessFlags.isProtected(this.accessFlags);
    }

    boolean isFinal() {
        return AsmAccessFlags.isFinal(this.accessFlags);
    }

    public boolean isDeprecated() {
        return AsmAccessFlags.isDeprecated(this.accessFlags);
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isUsed() {
        return this.used;
    }
}

