/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import java.util.Map;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Resource;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.SemanticModelProvider;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.SemanticModel;

public class SonarSymbolTableVisitor
extends JavaAstVisitor {
    private final ResourcePerspectives perspectives;
    private final SemanticModelProvider semanticModelProvider;

    public SonarSymbolTableVisitor(ResourcePerspectives perspectives, SemanticModelProvider semanticModelProvider) {
        this.perspectives = perspectives;
        this.semanticModelProvider = semanticModelProvider;
    }

    public void visitFile(AstNode astNode) {
        SemanticModel semanticModel = this.semanticModelProvider.semanticModel();
        if (semanticModel == null) {
            return;
        }
        JavaFile sonarFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)this.peekSourceFile().getKey());
        Symbolizable symbolizable = (Symbolizable)this.perspectives.as(Symbolizable.class, (Resource)sonarFile);
        Symbolizable.SymbolTableBuilder symbolTableBuilder = symbolizable.newSymbolTableBuilder();
        for (Map.Entry<AstNode, org.sonar.java.resolve.Symbol> entry : semanticModel.getSymbols().entrySet()) {
            AstNode declaration = entry.getKey();
            Symbol symbol = symbolTableBuilder.newSymbol(SonarSymbolTableVisitor.startOffsetFor(declaration), SonarSymbolTableVisitor.endOffsetFor(declaration));
            for (AstNode usage : semanticModel.getUsages(entry.getValue())) {
                symbolTableBuilder.newReference(symbol, SonarSymbolTableVisitor.startOffsetFor(usage));
            }
        }
        symbolizable.setSymbolTable(symbolTableBuilder.build());
    }

    private static int startOffsetFor(AstNode astNode) {
        return astNode.getFromIndex();
    }

    private static int endOffsetFor(AstNode astNode) {
        return astNode.getFromIndex() + astNode.getTokenValue().length();
    }
}

