/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.SemanticModelProvider;
import org.sonar.java.SemanticModelProviderAwareVisitor;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaTreeMaker;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

public class VisitorsBridge
extends JavaAstVisitor
implements SemanticModelProviderAwareVisitor {
    private final JavaTreeMaker treeMaker = new JavaTreeMaker();
    private final List<JavaFileScanner> scanners;
    private SemanticModelProvider semanticModelProvider;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Arrays.asList(visitor));
    }

    public VisitorsBridge(Iterable visitors) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
    }

    @Override
    public void setSemanticModelProvider(SemanticModelProvider semanticModelProvider) {
        this.semanticModelProvider = semanticModelProvider;
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (astNode != null) {
            CompilationUnitTree tree = this.treeMaker.compilationUnit(astNode);
            DefaultJavaFileScannerContext context = new DefaultJavaFileScannerContext(tree, this.peekSourceFile(), this.semanticModelProvider);
            for (JavaFileScanner scanner : this.scanners) {
                scanner.scanFile((JavaFileScannerContext)context);
            }
        }
    }

    private static class DefaultJavaFileScannerContext
    implements JavaFileScannerContext {
        private final CompilationUnitTree tree;
        private final SourceFile sourceFile;
        private final SemanticModelProvider semanticModelProvider;

        public DefaultJavaFileScannerContext(CompilationUnitTree tree, SourceFile sourceFile, SemanticModelProvider semanticModelProvider) {
            this.tree = tree;
            this.sourceFile = sourceFile;
            this.semanticModelProvider = semanticModelProvider;
        }

        public CompilationUnitTree getTree() {
            return this.tree;
        }

        public void addIssue(Tree tree, RuleKey ruleKey, String message) {
            Preconditions.checkNotNull((Object)ruleKey);
            Preconditions.checkNotNull((Object)message);
            int line = ((JavaTree)tree).getLine();
            CheckMessage checkMessage = new CheckMessage((Object)ruleKey, message, new Object[0]);
            checkMessage.setLine(line);
            this.sourceFile.log(checkMessage);
        }

        @Nullable
        public Object getSemanticModel() {
            return this.semanticModelProvider.semanticModel();
        }
    }
}

