/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sonar.sslr.squid.SquidAstVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.graph.DirectedGraph;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.JavaAstScanner;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.SemanticModelProviderAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.AstScanner;
import org.sonar.java.ast.visitors.ClassVisitor;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.FileVisitor;
import org.sonar.java.ast.visitors.PackageVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.ast.visitors.TestVisitor;
import org.sonar.java.bytecode.BytecodeScanner;
import org.sonar.java.bytecode.visitor.DependenciesVisitor;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceCodeEdge;
import org.sonar.squid.api.SourceCodeSearchEngine;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.indexer.SquidIndex;

public class JavaSquid
implements DirectedGraphAccessor<SourceCode, SourceCodeEdge>,
SourceCodeSearchEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSquid.class);
    private final SquidIndex squidIndex;
    private final AstScanner astScanner;
    private final AstScanner astScannerForTests;
    private final BytecodeScanner bytecodeScanner;
    private final DirectedGraph<SourceCode, SourceCodeEdge> graph = new DirectedGraph();
    private boolean bytecodeScanned = false;

    @VisibleForTesting
    public JavaSquid(JavaConfiguration conf, CodeVisitor ... visitors) {
        this(conf, (SonarComponents)null, visitors);
    }

    public JavaSquid(JavaConfiguration conf, @Nullable SonarComponents sonarComponents, CodeVisitor ... visitors) {
        this.astScanner = JavaAstScanner.create(conf, new SquidAstVisitor[0]);
        Iterable<Object> visitorsToBridge = Arrays.asList(visitors);
        if (sonarComponents != null) {
            visitorsToBridge = Iterables.concat(sonarComponents.createJavaFileScanners(), visitorsToBridge);
        }
        VisitorsBridge visitorsBridge = new VisitorsBridge(visitorsToBridge, sonarComponents);
        this.astScanner.accept((CodeVisitor)visitorsBridge);
        if (sonarComponents != null) {
            this.astScanner.accept((CodeVisitor)new FileLinesVisitor(sonarComponents, conf.getCharset()));
            this.astScanner.accept((CodeVisitor)new SyntaxHighlighterVisitor(sonarComponents, conf.getCharset()));
        }
        this.squidIndex = (SquidIndex)this.astScanner.getIndex();
        this.bytecodeScanner = new BytecodeScanner(this.squidIndex);
        this.bytecodeScanner.accept(new DependenciesVisitor(this.graph));
        for (CodeVisitor visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(conf.getCharset());
            }
            if (visitor instanceof SemanticModelProviderAwareVisitor) {
                ((SemanticModelProviderAwareVisitor)visitor).setSemanticModelProvider(visitorsBridge);
            }
            this.astScanner.accept(visitor);
            this.bytecodeScanner.accept(visitor);
        }
        this.astScannerForTests = new AstScanner(this.astScanner);
        this.astScannerForTests.accept((CodeVisitor)new PackageVisitor());
        this.astScannerForTests.accept((CodeVisitor)new FileVisitor());
        this.astScannerForTests.accept((CodeVisitor)new TestVisitor());
        this.astScannerForTests.accept((CodeVisitor)new ClassVisitor());
    }

    @VisibleForTesting
    public void scanDirectories(Collection<File> sourceDirectories, Collection<File> bytecodeFilesOrDirectories) {
        ArrayList sourceFiles = Lists.newArrayList();
        for (File dir : sourceDirectories) {
            sourceFiles.addAll(InputFileUtils.create((File)dir, (Collection)FileUtils.listFiles((File)dir, (String[])new String[]{"java"}, (boolean)true)));
        }
        this.scan(sourceFiles, Collections.<InputFile>emptyList(), bytecodeFilesOrDirectories);
    }

    public void scan(Collection<InputFile> sourceFiles, Collection<InputFile> testFiles, Collection<File> bytecodeFilesOrDirectories) {
        this.scanSources(sourceFiles);
        this.scanBytecode(bytecodeFilesOrDirectories);
        this.scanTests(testFiles);
    }

    private void scanSources(Collection<InputFile> sourceFiles) {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Main Files AST scan");
        this.astScanner.scan(sourceFiles);
        profiler.stop();
    }

    private void scanTests(Collection<InputFile> testFiles) {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Test Files AST scan");
        this.astScannerForTests.simpleScan(testFiles);
        profiler.stop();
    }

    private void scanBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (JavaSquid.hasBytecode(bytecodeFilesOrDirectories)) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java bytecode scan");
            this.bytecodeScanner.scan(bytecodeFilesOrDirectories);
            this.bytecodeScanned = true;
            profiler.stop();
        } else {
            LOG.warn("Java bytecode has not been made available to the analyzer. The " + Joiner.on((String)", ").join((Iterable)this.bytecodeScanner.getVisitors()) + " are disabled.");
            this.bytecodeScanned = false;
        }
    }

    static boolean hasBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (bytecodeFilesOrDirectories == null) {
            return false;
        }
        for (File bytecodeFilesOrDirectory : bytecodeFilesOrDirectories) {
            if (!bytecodeFilesOrDirectory.exists() || !bytecodeFilesOrDirectory.isFile() && FileUtils.listFiles((File)bytecodeFilesOrDirectory, (String[])new String[]{"class"}, (boolean)true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isBytecodeScanned() {
        return this.bytecodeScanned;
    }

    public SquidIndex getIndex() {
        return this.squidIndex;
    }

    public DirectedGraph<SourceCode, SourceCodeEdge> getGraph() {
        return this.graph;
    }

    public SourceCodeEdge getEdge(SourceCode from, SourceCode to) {
        return (SourceCodeEdge)this.graph.getEdge((Object)from, (Object)to);
    }

    public boolean hasEdge(SourceCode from, SourceCode to) {
        return this.graph.hasEdge((Object)from, (Object)to);
    }

    public Set<SourceCode> getVertices() {
        return this.graph.getVertices();
    }

    public Collection<SourceCodeEdge> getOutgoingEdges(SourceCode from) {
        return this.graph.getOutgoingEdges((Object)from);
    }

    public Collection<SourceCodeEdge> getIncomingEdges(SourceCode to) {
        return this.graph.getIncomingEdges((Object)to);
    }

    public List<SourceCodeEdge> getEdges(Collection<SourceCode> sourceCodes) {
        return this.graph.getEdges(sourceCodes);
    }

    public Collection<SourceCode> search(QueryByType queryByType) {
        return this.squidIndex.search(new Query[]{queryByType});
    }

    public SourceCode search(String key) {
        return this.squidIndex.search(key);
    }

    public Collection<SourceCode> search(Query ... query) {
        return this.squidIndex.search(query);
    }
}

