/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public abstract class JavaTree
implements Tree {
    private final AstNode astNode;

    public JavaTree(AstNode astNode) {
        this.astNode = astNode;
    }

    public AstNode getAstNode() {
        return this.astNode;
    }

    public int getLine() {
        return this.astNode.getTokenLine();
    }

    public final boolean is(Tree.Kind kind) {
        return this.getKind() == null ? false : this.getKind() == kind;
    }

    public abstract Tree.Kind getKind();

    public static class ArrayTypeTreeImpl
    extends AbstractTypedTree
    implements ArrayTypeTree {
        private final Tree type;

        public ArrayTypeTreeImpl(AstNode astNode, Tree type) {
            super(astNode);
            this.type = (Tree)Preconditions.checkNotNull((Object)type);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        public Tree type() {
            return this.type;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType((ArrayTypeTree)this);
        }
    }

    public static class AnnotationTreeImpl
    extends AbstractTypedTree
    implements AnnotationTree {
        private final List<ExpressionTree> arguments;
        private final Tree annotationType;

        public AnnotationTreeImpl(AstNode astNode, Tree annotationType, List<ExpressionTree> arguments) {
            super(astNode);
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        public Tree annotationType() {
            return this.annotationType;
        }

        public List<ExpressionTree> arguments() {
            return this.arguments;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ANNOTATION;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitAnnotation((AnnotationTree)this);
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends AbstractTypedTree
    implements ParameterizedTypeTree,
    ExpressionTree {
        private final ExpressionTree type;
        private final List<Tree> typeArguments;

        public ParameterizedTypeTreeImpl(AstNode child, ExpressionTree type, List<Tree> typeArguments) {
            super(child);
            this.type = (ExpressionTree)Preconditions.checkNotNull((Object)type);
            this.typeArguments = (List)Preconditions.checkNotNull(typeArguments);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        public Tree type() {
            return this.type;
        }

        public List<Tree> typeArguments() {
            return this.typeArguments;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType((ParameterizedTypeTree)this);
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends AbstractTypedTree
    implements PrimitiveTypeTree {
        public PrimitiveTypeTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType((PrimitiveTypeTree)this);
        }
    }

    public static class NotImplementedTreeImpl
    extends AbstractTypedTree
    implements ExpressionTree {
        private String name;

        public NotImplementedTreeImpl(AstNode astNode, String name) {
            super(astNode);
            this.name = name;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.OTHER;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitOther((Tree)this);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ModifiersTreeImpl
    extends JavaTree
    implements ModifiersTree {
        public static final ModifiersTreeImpl EMPTY = new ModifiersTreeImpl(null, (List<Modifier>)ImmutableList.of(), (List<AnnotationTree>)ImmutableList.of());
        private final List<Modifier> modifiers;
        private final List<AnnotationTree> annotations;

        public ModifiersTreeImpl(AstNode astNode, List<Modifier> modifiers, List<AnnotationTree> annotations) {
            super(astNode);
            this.modifiers = (List)Preconditions.checkNotNull(modifiers);
            this.annotations = (List)Preconditions.checkNotNull(annotations);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.MODIFIERS;
        }

        public List<Modifier> modifiers() {
            return this.modifiers;
        }

        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitModifier((ModifiersTree)this);
        }
    }

    public static class UnionTypeTreeImpl
    extends JavaTree
    implements UnionTypeTree {
        private final List<Tree> typeAlternatives;

        public UnionTypeTreeImpl(AstNode astNode, List<Tree> typeAlternatives) {
            super(astNode);
            this.typeAlternatives = (List)Preconditions.checkNotNull(typeAlternatives);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.UNION_TYPE;
        }

        public List<Tree> typeAlternatives() {
            return this.typeAlternatives;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType((UnionTypeTree)this);
        }
    }

    public static class WildcardTreeImpl
    extends JavaTree
    implements WildcardTree {
        private final Tree.Kind kind;
        @Nullable
        private final Tree bound;

        public WildcardTreeImpl(AstNode astNode, Tree.Kind kind, @Nullable Tree bound) {
            super(astNode);
            this.kind = (Tree.Kind)Preconditions.checkNotNull((Object)kind);
            this.bound = bound;
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        @Nullable
        public Tree bound() {
            return this.bound;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard((WildcardTree)this);
        }
    }

    public static class VariableTreeImpl
    extends JavaTree
    implements VariableTree {
        private final ModifiersTree modifiers;
        private final Tree type;
        private final IdentifierTree simpleName;
        @Nullable
        private final ExpressionTree initializer;
        private Symbol.VariableSymbol symbol;

        public VariableTreeImpl(AstNode astNode, ModifiersTree modifiers, Tree type, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
            super(astNode);
            this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
            this.type = (Tree)Preconditions.checkNotNull((Object)type);
            this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
            this.initializer = initializer;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.VARIABLE;
        }

        public ModifiersTree modifiers() {
            return this.modifiers;
        }

        public Tree type() {
            return this.type;
        }

        public IdentifierTree simpleName() {
            return this.simpleName;
        }

        @Nullable
        public ExpressionTree initializer() {
            return this.initializer;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitVariable((VariableTree)this);
        }

        public Symbol.VariableSymbol getSymbol() {
            return this.symbol;
        }

        public void setSymbol(Symbol.VariableSymbol symbol) {
            this.symbol = symbol;
        }
    }

    public static class EnumConstantTreeImpl
    extends VariableTreeImpl
    implements EnumConstantTree {
        public EnumConstantTreeImpl(AstNode astNode, ModifiersTree modifiers, Tree type, IdentifierTree simpleName, ExpressionTree initializer) {
            super(astNode, modifiers, type, simpleName, (ExpressionTree)Preconditions.checkNotNull((Object)initializer));
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ENUM_CONSTANT;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitEnumConstant((EnumConstantTree)this);
        }
    }

    public static class MethodTreeImpl
    extends JavaTree
    implements MethodTree {
        private final ModifiersTree modifiers;
        @Nullable
        private final Tree returnType;
        private final IdentifierTree simpleName;
        private final List<VariableTree> parameters;
        @Nullable
        private final BlockTree block;
        private final List<ExpressionTree> throwsClauses;
        private final ExpressionTree defaultValue;

        public MethodTreeImpl(AstNode astNode, ModifiersTree modifiers, @Nullable Tree returnType, IdentifierTree simpleName, List<VariableTree> parameters, @Nullable BlockTree block, List<ExpressionTree> throwsClauses, @Nullable ExpressionTree defaultValue) {
            super(astNode);
            this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
            this.returnType = returnType;
            this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
            this.parameters = (List)Preconditions.checkNotNull(parameters);
            this.block = block;
            this.throwsClauses = (List)Preconditions.checkNotNull(throwsClauses);
            this.defaultValue = defaultValue;
        }

        @Override
        public Tree.Kind getKind() {
            return this.returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD;
        }

        public ModifiersTree modifiers() {
            return this.modifiers;
        }

        public List<Tree> typeParameters() {
            return ImmutableList.of();
        }

        @Nullable
        public Tree returnType() {
            return this.returnType;
        }

        public IdentifierTree simpleName() {
            return this.simpleName;
        }

        public List<VariableTree> parameters() {
            return this.parameters;
        }

        public List<ExpressionTree> throwsClauses() {
            return this.throwsClauses;
        }

        @Nullable
        public BlockTree block() {
            return this.block;
        }

        @Nullable
        public ExpressionTree defaultValue() {
            return this.defaultValue;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitMethod((MethodTree)this);
        }
    }

    public static class ClassTreeImpl
    extends JavaTree
    implements ClassTree {
        private final Tree.Kind kind;
        private final ModifiersTree modifiers;
        private final IdentifierTree simpleName;
        @Nullable
        private final Tree superClass;
        private final List<Tree> superInterfaces;
        private final List<Tree> members;
        @Nullable
        private Symbol.TypeSymbol symbol;

        public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, @Nullable IdentifierTree simpleName, @Nullable Tree superClass, List<Tree> superInterfaces, List<Tree> members) {
            super(astNode);
            this.kind = (Tree.Kind)Preconditions.checkNotNull((Object)kind);
            this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
            this.simpleName = simpleName;
            this.superClass = superClass;
            this.superInterfaces = (List)Preconditions.checkNotNull(superInterfaces);
            this.members = (List)Preconditions.checkNotNull(members);
        }

        public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, List<Tree> members) {
            this(astNode, kind, modifiers, null, null, (List<Tree>)ImmutableList.of(), members);
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        @Nullable
        public IdentifierTree simpleName() {
            return this.simpleName;
        }

        public List<Tree> typeParameters() {
            return ImmutableList.of();
        }

        public ModifiersTree modifiers() {
            return this.modifiers;
        }

        @Nullable
        public Tree superClass() {
            return this.superClass;
        }

        public List<Tree> superInterfaces() {
            return this.superInterfaces;
        }

        public List<Tree> members() {
            return this.members;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitClass((ClassTree)this);
        }

        @Nullable
        public Symbol.TypeSymbol getSymbol() {
            return this.symbol;
        }

        public void setSymbol(Symbol.TypeSymbol symbol) {
            this.symbol = symbol;
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;

        public ImportTreeImpl(AstNode astNode, boolean aStatic, Tree qualifiedIdentifier) {
            super(astNode);
            this.isStatic = aStatic;
            this.qualifiedIdentifier = qualifiedIdentifier;
        }

        @Override
        public Tree.Kind getKind() {
            return null;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitImport((ImportTree)this);
        }
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        @Nullable
        private final ExpressionTree packageName;
        private final List<ImportTree> imports;
        private final List<Tree> types;
        private final List<AnnotationTree> packageAnnotations;

        public CompilationUnitTreeImpl(AstNode astNode, @Nullable ExpressionTree packageName, List<ImportTree> imports, List<Tree> types, List<AnnotationTree> packageAnnotations) {
            super(astNode);
            this.packageName = packageName;
            this.imports = (List)Preconditions.checkNotNull(imports);
            this.types = (List)Preconditions.checkNotNull(types);
            this.packageAnnotations = (List)Preconditions.checkNotNull(packageAnnotations);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        public List<AnnotationTree> packageAnnotations() {
            return this.packageAnnotations;
        }

        @Nullable
        public ExpressionTree packageName() {
            return this.packageName;
        }

        public List<ImportTree> imports() {
            return this.imports;
        }

        public List<Tree> types() {
            return this.types;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit((CompilationUnitTree)this);
        }
    }
}

