/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SecondPass;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class FirstPass
extends BaseTreeVisitor {
    private final SemanticModel semanticModel;
    private final List<Symbol> uncompleted = Lists.newArrayList();
    private final SecondPass completer;
    private final Symbols symbols;
    private Resolve resolve;
    private Resolve.Env env;

    public FirstPass(SemanticModel semanticModel, Symbols symbols, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.resolve = resolve;
        this.completer = new SecondPass(semanticModel, resolve, symbols);
        this.symbols = symbols;
    }

    private void restoreEnvironment(Tree tree) {
        if (this.env.next == null) {
            Preconditions.checkState((boolean)tree.is(Tree.Kind.COMPILATION_UNIT));
        } else {
            this.env = this.env.next;
        }
    }

    public void completeSymbols() {
        for (Symbol symbol : this.uncompleted) {
            symbol.complete();
        }
        this.uncompleted.clear();
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        Symbol.PackageSymbol compilationUnitPackage = this.symbols.defaultPackage;
        ExpressionTree packageName = tree.packageName();
        if (packageName != null) {
            PackageResolverVisitor packageResolver = new PackageResolverVisitor();
            packageName.accept((TreeVisitor)packageResolver);
            compilationUnitPackage = (Symbol.PackageSymbol)this.resolve.findIdentInPackage(this.env, compilationUnitPackage, packageResolver.packageName, 1);
            this.semanticModel.associateSymbol((Tree)packageName, compilationUnitPackage);
        }
        compilationUnitPackage.members = new Scope(compilationUnitPackage);
        this.env = new Resolve.Env();
        this.env.packge = compilationUnitPackage;
        this.env.scope = compilationUnitPackage.members;
        this.env.namedImports = new Scope(compilationUnitPackage);
        this.env.starImports = this.resolve.createStarImportScope(compilationUnitPackage);
        this.env.staticStarImports = this.resolve.createStaticStarImportScope(compilationUnitPackage);
        this.semanticModel.associateEnv((Tree)tree, this.env);
        super.visitCompilationUnit(tree);
        this.restoreEnvironment((Tree)tree);
        this.resolveImports(tree.imports());
        this.completeSymbols();
    }

    private void resolveImports(List<ImportTree> imports) {
        ImportResolverVisitor importResolverVisitor = new ImportResolverVisitor();
        for (ImportTree importTree : imports) {
            importTree.accept((TreeVisitor)importResolverVisitor);
        }
    }

    public void visitClass(ClassTree tree) {
        int flag = 0;
        boolean anonymousClass = tree.simpleName() == null;
        String name = "";
        if (!anonymousClass) {
            name = tree.simpleName().name();
            flag = this.computeClassFlags(tree);
        }
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(flag, name, this.env.scope.owner);
        ((JavaTree.ClassTreeImpl)tree).setSymbol(symbol);
        if (!anonymousClass) {
            if (this.env.scope.owner.kind == 2 || this.env.scope.owner.kind == 1) {
                this.resolve.registerClass(symbol);
            }
            this.enterSymbol((Tree)tree, symbol);
        }
        symbol.members = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
        Resolve.Env classEnv = this.env.dup();
        classEnv.outer = this.env;
        classEnv.enclosingClass = symbol;
        classEnv.scope = symbol.members;
        this.env = classEnv;
        this.semanticModel.associateEnv((Tree)tree, this.env);
        super.visitClass(tree);
        this.restoreEnvironment((Tree)tree);
    }

    private int computeClassFlags(ClassTree tree) {
        int flags = this.computeFlags(tree.modifiers());
        if (tree.is(Tree.Kind.INTERFACE)) {
            flags |= 0x200;
        } else if (tree.is(Tree.Kind.ENUM)) {
            flags |= 0x4000;
        } else if (tree.is(Tree.Kind.ANNOTATION_TYPE)) {
            flags |= 0x2200;
        }
        if (this.env.scope.owner instanceof Symbol.TypeSymbol && (this.env.enclosingClass.flags() & 0x200) != 0) {
            flags |= 1;
        }
        return flags;
    }

    public void visitMethod(MethodTree tree) {
        this.visitMethodDeclaration(tree);
        super.visitMethod(tree);
        this.restoreEnvironment((Tree)tree);
    }

    private void visitMethodDeclaration(MethodTree tree) {
        String name = tree.returnType() == null ? "<init>" : tree.simpleName().name();
        Symbol.MethodSymbol symbol = new Symbol.MethodSymbol(this.computeFlags(tree.modifiers()), name, this.env.scope.owner);
        this.enterSymbol((Tree)tree, symbol);
        symbol.parameters = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
        Resolve.Env methodEnv = this.env.dup();
        methodEnv.scope = symbol.parameters;
        this.env = methodEnv;
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.declareVariable(16385, tree.simpleName(), (Tree)tree);
        super.visitEnumConstant(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.declareVariable(this.computeFlags(tree.modifiers()), tree.simpleName(), (Tree)tree);
        super.visitVariable(tree);
    }

    private int computeFlags(ModifiersTree modifiers) {
        int result = 0;
        if ((this.env.scope.owner.flags & 0x200) != 0) {
            result = 1;
        }
        for (Modifier modifier : modifiers.modifiers()) {
            result |= Flags.flagForModifier(modifier);
        }
        return result;
    }

    private void declareVariable(int flags, IdentifierTree identifierTree, Tree tree) {
        Symbol.VariableSymbol symbol = new Symbol.VariableSymbol(flags, identifierTree.name(), this.env.scope.owner);
        this.enterSymbol(tree, symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
    }

    public void visitBlock(BlockTree tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitBlock(tree);
        this.restoreEnvironment((Tree)tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitForStatement(tree);
        this.restoreEnvironment((Tree)tree);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitForEachStatement(tree);
        this.restoreEnvironment((Tree)tree);
    }

    public void visitCatch(CatchTree tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitCatch(tree);
        this.restoreEnvironment((Tree)tree);
    }

    private void createNewEnvironment(Tree tree) {
        Scope scope = new Scope(this.env.scope);
        Resolve.Env newEnv = this.env.dup();
        newEnv.scope = scope;
        this.env = newEnv;
        this.semanticModel.associateEnv(tree, this.env);
    }

    private void enterSymbol(Tree tree, Symbol symbol) {
        this.env.scope.enter(symbol);
        this.semanticModel.associateSymbol(tree, symbol);
    }

    private class ImportResolverVisitor
    extends BaseTreeVisitor {
        private Symbol currentSymbol;
        private List<Symbol> resolved;
        private boolean isStatic;

        private ImportResolverVisitor() {
        }

        public void visitImport(ImportTree tree) {
            this.currentSymbol = ((FirstPass)FirstPass.this).symbols.defaultPackage;
            this.isStatic = tree.isStatic();
            super.visitImport(tree);
            if (this.currentSymbol.kind < 64) {
                this.enterSymbol(this.currentSymbol, tree);
            } else if (this.isStatic) {
                for (Symbol symbol : this.resolved) {
                    if ((symbol.flags & 8) == 0) continue;
                    this.enterSymbol(symbol, tree);
                }
            }
        }

        private void enterSymbol(Symbol symbol, ImportTree tree) {
            ((FirstPass)FirstPass.this).env.namedImports.enter(symbol);
            if (FirstPass.this.semanticModel.getSymbol((Tree)tree) == null && FirstPass.this.semanticModel.getTree(symbol) == null) {
                FirstPass.this.semanticModel.associateSymbol((Tree)tree, symbol);
            }
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (JavaPunctuator.STAR.getValue().equals(tree.name())) {
                if (this.isStatic) {
                    FirstPass.this.env.staticStarImports().enter(this.currentSymbol);
                } else {
                    FirstPass.this.env.starImports().enter(this.currentSymbol);
                }
                this.currentSymbol = new Resolve.SymbolNotFound();
            } else if (this.currentSymbol.kind == 1) {
                this.currentSymbol = FirstPass.this.resolve.findIdentInPackage(FirstPass.this.env, this.currentSymbol, tree.name(), 3);
                this.resolved = Collections.emptyList();
            } else if (this.currentSymbol.kind == 2) {
                this.resolved = ((Symbol.TypeSymbol)this.currentSymbol).members().lookup(tree.name());
                this.currentSymbol = FirstPass.this.resolve.findIdentInType(FirstPass.this.env, (Symbol.TypeSymbol)this.currentSymbol, tree.name(), 6);
            } else {
                this.currentSymbol = new Resolve.SymbolNotFound();
                this.resolved = Collections.emptyList();
            }
        }
    }

    private class PackageResolverVisitor
    extends BaseTreeVisitor {
        private String packageName = "";

        public void visitIdentifier(IdentifierTree tree) {
            if (!this.packageName.isEmpty()) {
                this.packageName = this.packageName + ".";
            }
            this.packageName = this.packageName + tree.name();
        }
    }
}

