/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

public class LabelsVisitor
extends BaseTreeVisitor {
    private final SemanticModel semanticModel;
    private final Map<String, LabeledStatementTree> labelTrees;

    public LabelsVisitor(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        this.labelTrees = Maps.newHashMap();
    }

    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.semanticModel.associateSymbol((Tree)tree, new Symbol(0, 0, tree.label().name(), null));
        this.labelTrees.put(tree.label().name(), tree);
        super.visitLabeledStatement(tree);
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        this.associateLabel(tree.label());
        super.visitBreakStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        this.associateLabel(tree.label());
        super.visitContinueStatement(tree);
    }

    private void associateLabel(@Nullable IdentifierTree label) {
        if (label == null) {
            return;
        }
        LabeledStatementTree labelTree = this.labelTrees.get(label.name());
        if (labelTree != null) {
            this.semanticModel.associateReference(label, this.semanticModel.getSymbol((Tree)labelTree));
        }
    }
}

