/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squidbridge.indexer.SquidIndex;

public class BytecodeVisitorNotifier {
    private final AsmClass asmClass;
    private final BytecodeVisitor[] bytecodeVisitors;

    public BytecodeVisitorNotifier(AsmClass asmClass, BytecodeVisitor[] bytecodeVisitors) {
        this.asmClass = asmClass;
        this.bytecodeVisitors = new BytecodeVisitor[bytecodeVisitors.length];
        System.arraycopy(bytecodeVisitors, 0, this.bytecodeVisitors, 0, bytecodeVisitors.length);
    }

    public void notifyVisitors(SquidIndex indexer) {
        for (BytecodeVisitor visitor : this.bytecodeVisitors) {
            visitor.setSquidIndex(indexer);
        }
        this.callVisitClass();
        this.callVisitMethodAndFieldAndEdge();
        this.callLeaveClass();
    }

    private void callVisitMethodAndFieldAndEdge() {
        this.callVisitEdgeForSpecificAsmResource(this.asmClass);
        for (AsmMethod method : this.asmClass.getMethods()) {
            this.callVisitMethod(method);
            this.callVisitEdgeForSpecificAsmResource(method);
        }
        for (AsmField field : this.asmClass.getFields()) {
            this.callVisitField(field);
            this.callVisitEdgeForSpecificAsmResource(field);
        }
    }

    private void callVisitEdgeForSpecificAsmResource(AsmResource resource) {
        for (AsmEdge edge : resource.getOutgoingEdges()) {
            for (BytecodeVisitor visitor : this.bytecodeVisitors) {
                visitor.visitEdge(edge);
            }
        }
    }

    private void callVisitMethod(AsmMethod asmMethod) {
        for (BytecodeVisitor visitor : this.bytecodeVisitors) {
            visitor.visitMethod(asmMethod);
        }
    }

    private void callVisitField(AsmField asmField) {
        for (BytecodeVisitor visitor : this.bytecodeVisitors) {
            visitor.visitField(asmField);
        }
    }

    private void callVisitClass() {
        for (BytecodeVisitor visitor : this.bytecodeVisitors) {
            visitor.visitClass(this.asmClass);
        }
    }

    private void callLeaveClass() {
        for (BytecodeVisitor visitor : this.bytecodeVisitors) {
            visitor.leaveClass(this.asmClass);
        }
    }
}

