/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Objects;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode) {
        return SyntacticEquivalence.areEquivalent((JavaTree)leftNode, (JavaTree)rightNode);
    }

    private static boolean areEquivalent(@Nullable JavaTree leftNode, @Nullable JavaTree rightNode) {
        if (leftNode == rightNode) {
            return true;
        }
        if (leftNode == null || rightNode == null) {
            return false;
        }
        if (leftNode.getKind() != rightNode.getKind()) {
            return false;
        }
        if (leftNode.isLeaf()) {
            return SyntacticEquivalence.areLeafsEquivalent(leftNode, rightNode);
        }
        if (leftNode.getKind() == Tree.Kind.OTHER) {
            return false;
        }
        Iterator<Tree> iteratorA = leftNode.childrenIterator();
        Iterator<Tree> iteratorB = rightNode.childrenIterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(iteratorA.next(), iteratorB.next())) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    private static boolean areLeafsEquivalent(JavaTree leftNode, JavaTree rightNode) {
        if (leftNode instanceof IdentifierTree) {
            return Objects.equal((Object)((IdentifierTree)((Object)leftNode)).name(), (Object)((IdentifierTree)((Object)rightNode)).name());
        }
        if (leftNode instanceof LiteralTree) {
            return Objects.equal((Object)((LiteralTree)((Object)leftNode)).value(), (Object)((LiteralTree)((Object)rightNode)).value());
        }
        if (leftNode instanceof PrimitiveTypeTree) {
            return Objects.equal((Object)((PrimitiveTypeTree)((Object)leftNode)).keyword().text(), (Object)((PrimitiveTypeTree)((Object)rightNode)).keyword().text());
        }
        throw new IllegalArgumentException();
    }
}

