/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class VariableTreeImpl
extends JavaTree
implements VariableTree {
    private final ModifiersTree modifiers;
    private final Tree type;
    private final IdentifierTree simpleName;
    @Nullable
    private final ExpressionTree initializer;
    private Symbol.VariableSymbol symbol;

    public VariableTreeImpl(AstNode astNode, ModifiersTree modifiers, Tree type, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
        super(astNode);
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.type = (Tree)Preconditions.checkNotNull((Object)type);
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.initializer = initializer;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.VARIABLE;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public Tree type() {
        return this.type;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    @Nullable
    public ExpressionTree initializer() {
        return this.initializer;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitVariable(this);
    }

    public Symbol.VariableSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol.VariableSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.modifiers, this.type, this.simpleName, this.initializer});
    }
}

