/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BinaryExpressionTreeImpl
extends AbstractTypedTree
implements BinaryExpressionTree {
    private final ExpressionTree leftOperand;
    private final Tree.Kind kind;
    private final ExpressionTree rightOperand;

    public BinaryExpressionTreeImpl(AstNode astNode, ExpressionTree leftOperand, Tree.Kind kind, ExpressionTree rightOperand) {
        super(astNode);
        this.leftOperand = (ExpressionTree)Preconditions.checkNotNull((Object)leftOperand);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.rightOperand = (ExpressionTree)Preconditions.checkNotNull((Object)rightOperand);
    }

    @Override
    public ExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public SyntaxToken operatorToken() {
        return new InternalSyntaxToken(this.astNode.getToken());
    }

    @Override
    public ExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public AstNode getAstNode() {
        return this.astNode.getParent();
    }

    @Override
    public int getLine() {
        return this.getAstNode().getTokenLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.leftOperand, this.rightOperand});
    }
}

