/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ConditionalExpressionTreeImpl
extends AbstractTypedTree
implements ConditionalExpressionTree {
    private final ExpressionTree condition;
    private final ExpressionTree trueExpression;
    private final ExpressionTree falseExpression;

    public ConditionalExpressionTreeImpl(AstNode astNode, ExpressionTree condition, ExpressionTree trueExpression, ExpressionTree falseExpression) {
        super(astNode);
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.trueExpression = (ExpressionTree)Preconditions.checkNotNull((Object)trueExpression);
        this.falseExpression = (ExpressionTree)Preconditions.checkNotNull((Object)falseExpression);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPRESSION;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken questionToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.QUERY}).getToken());
    }

    @Override
    public ExpressionTree trueExpression() {
        return this.trueExpression;
    }

    @Override
    public SyntaxToken colonToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.COLON}).getToken());
    }

    @Override
    public ExpressionTree falseExpression() {
        return this.falseExpression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.trueExpression, this.falseExpression});
    }
}

