/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class MethodInvocationTreeImpl
extends AbstractTypedTree
implements MethodInvocationTree {
    private final ExpressionTree methodSelect;
    private final List<ExpressionTree> arguments;

    public MethodInvocationTreeImpl(AstNode astNode, ExpressionTree methodSelect, List<ExpressionTree> arguments) {
        super(astNode);
        this.methodSelect = (ExpressionTree)Preconditions.checkNotNull((Object)methodSelect);
        this.arguments = (List)Preconditions.checkNotNull(arguments);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.METHOD_INVOCATION;
    }

    @Override
    public List<Tree> typeArguments() {
        return ImmutableList.of();
    }

    @Override
    public ExpressionTree methodSelect() {
        return this.methodSelect;
    }

    @Override
    public SyntaxToken openParenToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    public SyntaxToken closeParenToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethodInvocation(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.methodSelect), this.arguments.iterator());
    }
}

