/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class NewArrayTreeImpl
extends AbstractTypedTree
implements NewArrayTree {
    private final Tree type;
    private final List<ExpressionTree> dimensions;
    private final List<ExpressionTree> initializers;

    public NewArrayTreeImpl(AstNode astNode, Tree type, List<ExpressionTree> dimensions, List<ExpressionTree> initializers) {
        super(astNode);
        this.type = type;
        this.dimensions = (List)Preconditions.checkNotNull(dimensions);
        this.initializers = (List)Preconditions.checkNotNull(initializers);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NEW_ARRAY;
    }

    @Override
    public Tree type() {
        return this.type;
    }

    @Override
    public List<ExpressionTree> dimensions() {
        return this.dimensions;
    }

    @Override
    public List<ExpressionTree> initializers() {
        return this.initializers;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNewArray(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.type), this.dimensions.iterator(), this.initializers.iterator());
    }
}

