/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class IfStatementTreeImpl
extends JavaTree
implements IfStatementTree {
    private final ExpressionTree condition;
    private final StatementTree thenStatement;
    @Nullable
    private final StatementTree elseStatement;

    public IfStatementTreeImpl(AstNode astNode, ExpressionTree condition, StatementTree thenStatement, @Nullable StatementTree elseStatement) {
        super(astNode);
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.thenStatement = (StatementTree)Preconditions.checkNotNull((Object)thenStatement);
        this.elseStatement = elseStatement;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF_STATEMENT;
    }

    @Override
    public SyntaxToken ifKeyword() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.IF}).getToken());
    }

    @Override
    public SyntaxToken openParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getToken());
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaGrammar.PAR_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getToken());
    }

    @Override
    public StatementTree thenStatement() {
        return this.thenStatement;
    }

    @Override
    @Nullable
    public SyntaxToken elseKeyword() {
        return this.elseStatement == null ? null : new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.ELSE}).getToken());
    }

    @Override
    @Nullable
    public StatementTree elseStatement() {
        return this.elseStatement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIfStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.thenStatement, this.elseStatement});
    }
}

