/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BlockTreeImpl
extends JavaTree
implements BlockTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken openBraceToken;
    private final List<StatementTree> body;
    private final InternalSyntaxToken closeBraceToken;

    public BlockTreeImpl(InternalSyntaxToken openBraceToken, List<StatementTree> body, InternalSyntaxToken closeBraceToken, AstNode ... children) {
        this(Tree.Kind.BLOCK, openBraceToken, body, closeBraceToken, children);
    }

    public BlockTreeImpl(Tree.Kind kind, InternalSyntaxToken openBraceToken, List<StatementTree> body, InternalSyntaxToken closeBraceToken, AstNode ... children) {
        super(kind);
        this.kind = kind;
        this.openBraceToken = openBraceToken;
        this.body = (List)Preconditions.checkNotNull(body);
        this.closeBraceToken = closeBraceToken;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public BlockTreeImpl(AstNode astNode, Tree.Kind newKind, BlockTreeImpl block) {
        super(astNode);
        this.kind = newKind;
        this.openBraceToken = block.openBraceToken;
        this.body = block.body;
        this.closeBraceToken = block.closeBraceToken;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return this.openBraceToken;
    }

    @Override
    public List<StatementTree> body() {
        return this.body;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return this.closeBraceToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBlock(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.emptyIterator(), this.body.iterator());
    }
}

