/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SecondPass
implements Symbol.Completer {
    private final SemanticModel semanticModel;
    private final Resolve resolve;
    private final Symbols symbols;

    public SecondPass(SemanticModel semanticModel, Resolve resolve, Symbols symbols) {
        this.semanticModel = semanticModel;
        this.resolve = resolve;
        this.symbols = symbols;
    }

    @Override
    public void complete(Symbol symbol) {
        if (symbol.kind == 2) {
            this.complete((Symbol.TypeSymbol)symbol);
        } else if (symbol.kind == 16) {
            this.complete((Symbol.MethodSymbol)symbol);
        } else if (symbol.kind == 4) {
            this.complete((Symbol.VariableSymbol)symbol);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void complete(Symbol.TypeSymbol symbol) {
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        Type.ClassType type = (Type.ClassType)symbol.type;
        if ((symbol.flags() & 0x200) == 0) {
            symbol.members.enter(new Symbol.VariableSymbol(16, "this", symbol.type, (Symbol)symbol));
        }
        if ("".equals(symbol.name)) {
            type.interfaces = ImmutableList.of();
            return;
        }
        ClassTree tree = (ClassTree)this.semanticModel.getTree(symbol);
        Tree superClassTree = tree.superClass();
        if (superClassTree != null) {
            type.supertype = this.resolveType(env, superClassTree);
            this.checkHierarchyCycles(symbol.type);
        } else if (tree.is(Tree.Kind.ENUM)) {
            type.supertype = this.symbols.enumType;
        } else if (tree.is(Tree.Kind.CLASS)) {
            type.supertype = this.symbols.objectType;
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        for (Tree interfaceTree : tree.superInterfaces()) {
            Type interfaceType = this.resolveType(env, interfaceTree);
            if (interfaceType == null) continue;
            interfaces.add((Object)interfaceType);
        }
        if (tree.is(Tree.Kind.ANNOTATION_TYPE)) {
            interfaces.add((Object)this.symbols.annotationType);
        }
        type.interfaces = interfaces.build();
    }

    private void checkHierarchyCycles(Type baseType) {
        HashSet types = Sets.newHashSet();
        Type.ClassType type = (Type.ClassType)baseType;
        while (type != null) {
            if (!types.add(type)) {
                throw new IllegalStateException("Cycling class hierarchy detected with symbol : " + baseType.symbol.name + ".");
            }
            type = (Type.ClassType)type.symbol.getSuperclass();
        }
    }

    private void complete(Symbol.MethodSymbol symbol) {
        MethodTree methodTree = (MethodTree)this.semanticModel.getTree(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        ImmutableList.Builder thrown = ImmutableList.builder();
        ImmutableList.Builder thrownTypes = ImmutableList.builder();
        for (ExpressionTree throwClause : methodTree.throwsClauses()) {
            Type thrownType = this.resolveType(env, throwClause);
            if (thrownType == null) continue;
            thrownTypes.add((Object)thrownType);
            ((AbstractTypedTree)((Object)throwClause)).setType(thrownType);
            thrown.add((Object)((Type.ClassType)thrownType).symbol);
        }
        symbol.thrown = thrown.build();
        Type returnType = null;
        if (!"<init>".equals(symbol.name) && (returnType = this.resolveType(env, methodTree.returnType())) != null) {
            symbol.type = returnType.symbol;
        }
        ArrayList argTypes = Lists.newArrayList();
        Collection<Symbol> scopeSymbols = symbol.parameters.scopeSymbols();
        for (VariableTree variableTree : methodTree.parameters()) {
            for (Symbol param : scopeSymbols) {
                if (!variableTree.simpleName().name().equals(param.getName())) continue;
                param.complete();
                argTypes.add(param.getType());
            }
        }
        Type.MethodType methodType = new Type.MethodType(argTypes, returnType, (List<Type>)thrownTypes.build(), (Symbol.TypeSymbol)symbol.owner);
        symbol.setMethodType(methodType);
    }

    private void complete(Symbol.VariableSymbol symbol) {
        VariableTree variableTree = (VariableTree)this.semanticModel.getTree(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        symbol.type = variableTree.is(Tree.Kind.ENUM_CONSTANT) ? env.enclosingClass().type : this.resolveType(env, variableTree.type());
    }

    private Type resolveType(Resolve.Env env, Tree tree) {
        Preconditions.checkArgument((boolean)this.checkTypeOfTree(tree), (Object)("Kind of tree unexpected " + (Object)((Object)((JavaTree)tree).getKind())));
        TypeResolverVisitor typeResolverVisitor = new TypeResolverVisitor(env.dup());
        tree.accept(typeResolverVisitor);
        if (typeResolverVisitor.arrayType != null) {
            return typeResolverVisitor.arrayType;
        }
        return this.castToTypeIfPossible(typeResolverVisitor.site);
    }

    private boolean checkTypeOfTree(Tree tree) {
        return tree.is(Tree.Kind.MEMBER_SELECT) || tree.is(Tree.Kind.IDENTIFIER) || tree.is(Tree.Kind.PARAMETERIZED_TYPE) || tree.is(Tree.Kind.ARRAY_TYPE) || tree.is(Tree.Kind.UNION_TYPE) || tree.is(Tree.Kind.PRIMITIVE_TYPE) || tree.is(Tree.Kind.INFERED_TYPE);
    }

    private Type castToTypeIfPossible(Symbol symbol) {
        return symbol instanceof Symbol.TypeSymbol ? ((Symbol.TypeSymbol)symbol).type : this.symbols.unknownType;
    }

    private void associateReference(IdentifierTree tree, Symbol symbol) {
        if (symbol.kind < 64 && this.semanticModel.getTree(symbol) != null) {
            this.semanticModel.associateReference(tree, symbol);
        }
    }

    private class TypeResolverVisitor
    extends BaseTreeVisitor {
        private final Resolve.Env env;
        private Symbol site;
        private Type.ArrayType arrayType;

        public TypeResolverVisitor(Resolve.Env env) {
            this.env = env;
        }

        @Override
        public void visitParameterizedType(ParameterizedTypeTree tree) {
            this.scan(tree.type());
        }

        @Override
        public void visitArrayType(ArrayTypeTree tree) {
            super.visitArrayType(tree);
            this.arrayType = this.arrayType == null ? new Type.ArrayType(this.site.type, ((SecondPass)SecondPass.this).symbols.arrayClass) : new Type.ArrayType(this.arrayType, ((SecondPass)SecondPass.this).symbols.arrayClass);
        }

        @Override
        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            this.scan(tree.expression());
            if (this.site.kind >= 64) {
                return;
            }
            String name = tree.identifier().name();
            if (this.site.kind == 1) {
                this.env.packge = (Symbol.PackageSymbol)this.site;
                this.site = SecondPass.this.resolve.findIdentInPackage(this.env, this.site, name, 3);
            } else {
                this.env.enclosingClass = (Symbol.TypeSymbol)this.site;
                this.site = SecondPass.this.resolve.findMemberType(this.env, (Symbol.TypeSymbol)this.site, name, (Symbol.TypeSymbol)this.site);
            }
            SecondPass.this.associateReference(tree.identifier(), this.site);
        }

        @Override
        public void visitIdentifier(IdentifierTree tree) {
            this.site = SecondPass.this.resolve.findIdent(this.env, tree.name(), 3);
            SecondPass.this.associateReference(tree, this.site);
        }

        @Override
        public void visitPrimitiveType(PrimitiveTypeTree tree) {
            this.site = SecondPass.this.resolve.findIdent(SecondPass.this.semanticModel.getEnv(tree), tree.keyword().text(), 2);
        }
    }
}

