/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.parser.sslr.ActionParser2;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public class PrinterVisitor
extends BaseTreeVisitor {
    private static final int INDENT_SPACES = 2;
    private static final Logger LOG = LoggerFactory.getLogger(PrinterVisitor.class);
    private final StringBuilder sb;
    private final SemanticModel semanticModel;
    private final Map<IdentifierTree, Symbol> idents = new HashMap<IdentifierTree, Symbol>();
    private int indentLevel = 0;

    public PrinterVisitor(@Nullable SemanticModel semanticModel) {
        this.sb = new StringBuilder();
        this.semanticModel = semanticModel;
    }

    public static String print(Tree tree) {
        return PrinterVisitor.print(tree, null);
    }

    public static String print(Tree tree, @Nullable SemanticModel semanticModel) {
        PrinterVisitor pv = new PrinterVisitor(semanticModel);
        pv.scan(tree);
        return pv.sb.toString();
    }

    public static String print(List<? extends Tree> trees) {
        StringBuilder result = new StringBuilder();
        for (Tree tree : trees) {
            result.append(PrinterVisitor.print(tree));
        }
        return result.toString();
    }

    private StringBuilder indent() {
        return this.sb.append(StringUtils.leftPad((String)"", (int)(2 * this.indentLevel)));
    }

    @Override
    protected void scan(List<? extends Tree> trees) {
        if (!trees.isEmpty()) {
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.sb.append(" : [\n");
            super.scan(trees);
            this.indent().append("]\n");
        }
    }

    @Override
    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            Symbol sym = null;
            try {
                Method getSymbol = null;
                for (Method method : tree.getClass().getMethods()) {
                    if (!"getSymbol".equals(method.getName())) continue;
                    getSymbol = tree.getClass().getMethod("getSymbol", new Class[0]);
                }
                if (getSymbol != null) {
                    sym = (Symbol)getSymbol.invoke((Object)tree, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.error("An error occured while retrieving symbol ", (Throwable)e);
            }
            Tree.Kind kind = ((JavaTree)tree).getKind();
            String nodeName = ((JavaTree)tree).getClass().getSimpleName();
            if (kind != null) {
                nodeName = kind.getAssociatedInterface().getSimpleName();
            }
            this.indent().append(nodeName);
            int line = -1;
            AstNode node = ((JavaTree)tree).getAstNode();
            if (node != null && node.hasToken()) {
                line = node.getTokenLine();
                this.sb.append(" ").append(line);
            }
            if (this.idents.get(tree) != null) {
                Preconditions.checkState((sym == null ? 1 : 0) != 0);
                sym = this.idents.get(tree);
            }
            if (tree instanceof AbstractTypedTree) {
                this.sb.append(" ").append(((AbstractTypedTree)tree).getSymbolType());
            }
            if (sym != null && this.semanticModel != null) {
                for (IdentifierTree identifierTree : this.semanticModel.getUsages(sym)) {
                    this.idents.put(identifierTree, sym);
                    this.sb.append(" ").append(sym.getName());
                }
                int refLine = ((JavaTree)this.semanticModel.getTree(sym)).getTokenLine();
                if (refLine != line) {
                    this.sb.append(" ref#").append(refLine);
                }
            }
            this.sb.append("\n");
        }
        ++this.indentLevel;
        super.scan(tree);
        --this.indentLevel;
    }

    public static String printFile(String file, String bytecodePath) {
        ActionParser2 p = JavaParser.createParser(Charsets.UTF_8);
        CompilationUnitTree cut = (CompilationUnitTree)p.parse(new File(file));
        SemanticModel semanticModel = SemanticModel.createFor(cut, Lists.newArrayList((Object[])new File[]{new File(bytecodePath)}));
        return PrinterVisitor.print(cut, semanticModel);
    }
}

