/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.resolve.BytecodeVisitor;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;

public class BytecodeCompleter
implements Symbol.Completer {
    private static final Logger LOG = LoggerFactory.getLogger(BytecodeCompleter.class);
    private static final int ACCEPTABLE_BYTECODE_FLAGS = 159743;
    private Symbols symbols;
    private final List<File> projectClasspath;
    private final Map<String, Symbol.TypeSymbol> classes = new HashMap<String, Symbol.TypeSymbol>();
    private final Map<String, Symbol.PackageSymbol> packages = new HashMap<String, Symbol.PackageSymbol>();
    private ClassLoader classLoader;

    public BytecodeCompleter(List<File> projectClasspath) {
        this.projectClasspath = projectClasspath;
    }

    public void init(Symbols symbols) {
        this.symbols = symbols;
    }

    public Symbol.TypeSymbol registerClass(Symbol.TypeSymbol classSymbol) {
        String flatName = this.formFullName(classSymbol);
        Preconditions.checkState((!this.classes.containsKey(flatName) ? 1 : 0) != 0, (Object)("Registering class 2 times : " + flatName));
        this.classes.put(flatName, classSymbol);
        return classSymbol;
    }

    @Override
    public void complete(Symbol symbol) {
        String bytecodeName;
        Symbol.TypeSymbol classSymbol;
        LOG.debug("Completing symbol : " + symbol.name);
        if (symbol.owner.isKind(2)) {
            symbol.owner.complete();
        }
        Preconditions.checkState(((classSymbol = this.getClassSymbol(bytecodeName = this.formFullName(symbol))) == symbol ? 1 : 0) != 0);
        InputStream inputStream = null;
        ClassReader classReader = null;
        try {
            inputStream = this.inputStreamFor(bytecodeName);
            classReader = new ClassReader(inputStream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        if (classReader != null) {
            classReader.accept((ClassVisitor)new BytecodeVisitor(this, this.symbols, (Symbol.TypeSymbol)symbol), 7);
        }
    }

    private InputStream inputStreamFor(String fullname) {
        return this.getClassLoader().getResourceAsStream(Convert.bytecodeName(fullname) + ".class");
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderBuilder.create(this.projectClasspath);
        }
        return this.classLoader;
    }

    public String formFullName(Symbol symbol) {
        return this.formFullName(symbol.name, symbol.owner);
    }

    public String formFullName(String name, Symbol site) {
        String result = name;
        for (Symbol owner = site; owner != this.symbols.defaultPackage; owner = owner.owner()) {
            String separator = ".";
            if (owner.kind == 2) {
                separator = "$";
            }
            result = owner.name + separator + result;
        }
        return result;
    }

    @VisibleForTesting
    Symbol.TypeSymbol getClassSymbol(String bytecodeName) {
        return this.getClassSymbol(bytecodeName, 0);
    }

    Symbol.TypeSymbol getClassSymbol(String bytecodeName, int flags) {
        String flatName = Convert.flatName(bytecodeName);
        Symbol.TypeSymbol symbol = this.classes.get(flatName);
        if (symbol == null) {
            String shortName = Convert.shortName(flatName);
            String packageName = Convert.packagePart(flatName);
            String enclosingClassName = Convert.enclosingClassName(shortName);
            symbol = StringUtils.isNotEmpty((String)enclosingClassName) ? new Symbol.TypeSymbol(this.filterBytecodeFlags(flags), Convert.innerClassName(shortName), this.getClassSymbol(Convert.fullName(packageName, enclosingClassName))) : new Symbol.TypeSymbol(this.filterBytecodeFlags(flags), shortName, this.enterPackage(packageName));
            symbol.members = new Scope(symbol);
            if (this.getClassLoader().getResource(Convert.bytecodeName(flatName) + ".class") != null) {
                symbol.completer = this;
            } else {
                LOG.error("Class not found: " + bytecodeName);
                ((Type.ClassType)symbol.type).interfaces = ImmutableList.of();
            }
            this.classes.put(flatName, symbol);
        }
        return symbol;
    }

    public int filterBytecodeFlags(int flags) {
        return flags & 0x26FFF;
    }

    public Symbol loadClass(String fullname) {
        Symbol.TypeSymbol symbol = this.classes.get(fullname);
        if (symbol != null) {
            return symbol;
        }
        InputStream inputStream = this.inputStreamFor(fullname);
        String bytecodeName = Convert.bytecodeName(fullname);
        if (inputStream == null) {
            return new Resolve.SymbolNotFound();
        }
        try {
            ClassReader classReader = new ClassReader(inputStream);
            String className = classReader.getClassName();
            if (!className.equals(bytecodeName)) {
                Resolve.SymbolNotFound symbolNotFound = new Resolve.SymbolNotFound();
                return symbolNotFound;
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        return this.getClassSymbol(fullname);
    }

    public Symbol.PackageSymbol enterPackage(String fullname) {
        if (StringUtils.isBlank((String)fullname)) {
            return this.symbols.defaultPackage;
        }
        Symbol.PackageSymbol result = this.packages.get(fullname);
        if (result == null) {
            result = new Symbol.PackageSymbol(fullname, this.symbols.defaultPackage);
            this.packages.put(fullname, result);
        }
        return result;
    }

    public void done() {
        if (this.classLoader != null && this.classLoader instanceof Closeable) {
            Closeables.closeQuietly((Closeable)((Closeable)((Object)this.classLoader)));
        }
    }

    static boolean isSynthetic(int flags) {
        return (flags & 0x1000) != 0;
    }
}

