/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.java.resolve.AnnotationInstance;
import org.sonar.java.resolve.BytecodeAnnotationVisitor;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;

public class BytecodeVisitor
extends ClassVisitor {
    private BytecodeCompleter bytecodeCompleter;
    private final Symbols symbols;
    private final Symbol.TypeSymbol classSymbol;
    private String className;

    BytecodeVisitor(BytecodeCompleter bytecodeCompleter, Symbols symbols, Symbol.TypeSymbol classSymbol) {
        super(327680);
        this.bytecodeCompleter = bytecodeCompleter;
        this.symbols = symbols;
        this.classSymbol = classSymbol;
    }

    private Symbol.TypeSymbol getClassSymbol(String bytecodeName) {
        return this.bytecodeCompleter.getClassSymbol(Convert.flatName(bytecodeName));
    }

    private Symbol.TypeSymbol getClassSymbol(String bytecodeName, int flags) {
        return this.bytecodeCompleter.getClassSymbol(Convert.flatName(bytecodeName), flags);
    }

    public void visit(int version, int flags, String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Preconditions.checkState((boolean)name.endsWith(this.classSymbol.name), (Object)("Name : '" + name + "' should ends with " + this.classSymbol.name));
        Preconditions.checkState((!BytecodeCompleter.isSynthetic(flags) ? 1 : 0) != 0, (Object)(name + " is synthetic"));
        this.className = name;
        if (signature != null) {
            new SignatureReader(signature).accept(new SignatureVisitor(327680){

                public void visitFormalTypeParameter(String name) {
                    ((BytecodeVisitor)BytecodeVisitor.this).classSymbol.isParametrized = true;
                }
            });
        }
        this.classSymbol.flags = (this.classSymbol.flags & 7) != 0 ? (this.classSymbol.flags |= this.bytecodeCompleter.filterBytecodeFlags(flags & 0xFFFFFFF8)) : (this.classSymbol.flags |= this.bytecodeCompleter.filterBytecodeFlags(flags));
        this.classSymbol.members = new Scope(this.classSymbol);
        if (superName == null) {
            Preconditions.checkState((boolean)"java/lang/Object".equals(this.className), (Object)("superName must be null only for java/lang/Object, but not for " + this.className));
        } else {
            ((Type.ClassType)this.classSymbol.type).supertype = this.getClassSymbol((String)superName).type;
        }
        ((Type.ClassType)this.classSymbol.type).interfaces = this.getCompletedClassSymbolsType(interfaces);
    }

    public void visitSource(@Nullable String source, @Nullable String debug) {
        throw new IllegalStateException();
    }

    public void visitOuterClass(String owner, String name, String desc) {
        throw new IllegalStateException();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type annotationType = this.convertAsmType(org.objectweb.asm.Type.getType((String)desc));
        AnnotationInstance annotationInstance = new AnnotationInstance(annotationType.getSymbol());
        this.classSymbol.metadata().addAnnotation(annotationInstance);
        return new BytecodeAnnotationVisitor(annotationInstance, this);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int flags) {
        if (!BytecodeCompleter.isSynthetic(flags) && innerName != null && outerName != null) {
            if (this.className.equals(outerName)) {
                this.defineInnerClass(name, flags);
            } else if (this.className.equals(name)) {
                this.defineOuterClass(outerName, innerName, flags);
            }
        }
    }

    private void defineInnerClass(String bytecodeName, int flags) {
        Symbol.TypeSymbol innerClass = this.getClassSymbol(bytecodeName, flags);
        innerClass.flags |= this.bytecodeCompleter.filterBytecodeFlags(flags);
        Preconditions.checkState((innerClass.owner == this.classSymbol ? 1 : 0) != 0, (Object)("Innerclass: " + innerClass.owner.getName() + " and classSymbol: " + this.classSymbol.getName() + " are not the same."));
        this.classSymbol.members.enter(innerClass);
    }

    private void defineOuterClass(String outerName, String innerName, int flags) {
        Symbol.TypeSymbol outerClassSymbol = this.getClassSymbol(outerName, flags);
        Preconditions.checkState((outerClassSymbol.completer == null || outerClassSymbol.completer instanceof BytecodeCompleter ? 1 : 0) != 0);
        this.classSymbol.name = innerName;
        this.classSymbol.owner = outerClassSymbol;
    }

    public FieldVisitor visitField(int flags, String name, String desc, @Nullable String signature, @Nullable Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)desc);
        if (!BytecodeCompleter.isSynthetic(flags)) {
            final Symbol.VariableSymbol symbol = new Symbol.VariableSymbol(this.bytecodeCompleter.filterBytecodeFlags(flags), name, this.convertAsmType(org.objectweb.asm.Type.getType((String)desc)), (Symbol)this.classSymbol);
            this.classSymbol.members.enter(symbol);
            if (signature != null) {
                new SignatureReader(signature).accept(new SignatureVisitor(327680){

                    public void visitFormalTypeParameter(String name) {
                        symbol.isParametrized = true;
                    }
                });
            }
        }
        return null;
    }

    public MethodVisitor visitMethod(int flags, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)desc);
        if (!BytecodeCompleter.isSynthetic(flags)) {
            Preconditions.checkState(((flags & 0x40) == 0 ? 1 : 0) != 0, (Object)("bridge method not marked as synthetic in class " + this.className));
            Type.MethodType type = new Type.MethodType(this.convertAsmTypes(org.objectweb.asm.Type.getArgumentTypes((String)desc)), this.convertAsmType(org.objectweb.asm.Type.getReturnType((String)desc)), this.getCompletedClassSymbolsType(exceptions), this.classSymbol);
            final Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(this.bytecodeCompleter.filterBytecodeFlags(flags), name, type, (Symbol)this.classSymbol);
            this.classSymbol.members.enter(methodSymbol);
            if (signature != null) {
                new SignatureReader(signature).accept(new SignatureVisitor(327680){

                    public void visitFormalTypeParameter(String name) {
                        methodSymbol.isParametrized = true;
                    }
                });
            }
        }
        return null;
    }

    private List<Type> convertAsmTypes(org.objectweb.asm.Type[] asmTypes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (org.objectweb.asm.Type asmType : asmTypes) {
            result.add((Object)this.convertAsmType(asmType));
        }
        return result.build();
    }

    public Type convertAsmType(org.objectweb.asm.Type asmType) {
        Type result;
        switch (asmType.getSort()) {
            case 10: {
                result = this.getClassSymbol((String)asmType.getInternalName()).type;
                break;
            }
            case 3: {
                result = this.symbols.byteType;
                break;
            }
            case 2: {
                result = this.symbols.charType;
                break;
            }
            case 4: {
                result = this.symbols.shortType;
                break;
            }
            case 5: {
                result = this.symbols.intType;
                break;
            }
            case 7: {
                result = this.symbols.longType;
                break;
            }
            case 6: {
                result = this.symbols.floatType;
                break;
            }
            case 8: {
                result = this.symbols.doubleType;
                break;
            }
            case 1: {
                result = this.symbols.booleanType;
                break;
            }
            case 9: {
                result = new Type.ArrayType(this.convertAsmType(asmType.getElementType()), this.symbols.arrayClass);
                break;
            }
            case 0: {
                result = this.symbols.voidType;
                break;
            }
            default: {
                throw new IllegalArgumentException(asmType.toString());
            }
        }
        return result;
    }

    public void visitEnd() {
        if (this.classSymbol.owner == null) {
            String flatName = this.className.replace('/', '.');
            this.classSymbol.name = flatName.substring(flatName.lastIndexOf(46) + 1);
            this.classSymbol.owner = this.bytecodeCompleter.enterPackage(flatName);
            Symbol.PackageSymbol owner = (Symbol.PackageSymbol)this.classSymbol.owner;
            if (owner.members == null) {
                owner.members = new Scope(owner);
            }
            owner.members.enter(this.classSymbol);
        }
    }

    private List<Type> getCompletedClassSymbolsType(@Nullable String[] bytecodeNames) {
        if (bytecodeNames == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (String bytecodeName : bytecodeNames) {
            types.add((Object)this.getClassSymbol((String)bytecodeName).type);
        }
        return types.build();
    }
}

