/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SonarSymbolTableVisitor
extends BaseTreeVisitor {
    private final SemanticModel semanticModel;
    private final Symbolizable symbolizable;
    private final Symbolizable.SymbolTableBuilder symbolTableBuilder;
    private CompilationUnitTree outerClass;

    public SonarSymbolTableVisitor(Symbolizable symbolizable, SemanticModel semanticModel) {
        this.symbolizable = symbolizable;
        this.semanticModel = semanticModel;
        this.symbolTableBuilder = symbolizable.newSymbolTableBuilder();
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (this.outerClass == null) {
            this.outerClass = tree;
        }
        super.visitCompilationUnit(tree);
        if (tree.equals(this.outerClass)) {
            this.symbolizable.setSymbolTable(this.symbolTableBuilder.build());
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        if (tree.simpleName() != null) {
            this.createSymbol(tree, tree.simpleName());
        }
        for (TypeParameterTree typeParameterTree : tree.typeParameters()) {
            this.createSymbol(typeParameterTree, typeParameterTree.identifier());
        }
        super.visitClass(tree);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.createSymbol(tree, tree.simpleName());
        super.visitVariable(tree);
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.createSymbol(tree, tree.simpleName());
        super.visitEnumConstant(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.createSymbol(tree, tree.simpleName());
        super.visitMethod(tree);
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.createSymbol(tree, tree.label());
        super.visitLabeledStatement(tree);
    }

    @Override
    public void visitImport(ImportTree tree) {
        IdentifierTree identifierTree = tree.qualifiedIdentifier().is(Tree.Kind.IDENTIFIER) ? (IdentifierTree)tree.qualifiedIdentifier() : ((MemberSelectExpressionTree)tree.qualifiedIdentifier()).identifier();
        if (!"*".equals(identifierTree.name())) {
            this.createSymbol(tree, identifierTree);
        }
        super.visitImport(tree);
    }

    private void createSymbol(Tree tree, IdentifierTree identifier) {
        Symbol symbol = this.symbolTableBuilder.newSymbol(this.startOffsetFor(identifier), this.endOffsetFor(identifier));
        for (IdentifierTree usage : this.semanticModel.getUsages(this.semanticModel.getSymbol(tree))) {
            this.symbolTableBuilder.newReference(symbol, this.startOffsetFor(usage));
        }
    }

    private int startOffsetFor(IdentifierTree tree) {
        return ((InternalSyntaxToken)tree.identifierToken()).getFromIndex();
    }

    private int endOffsetFor(IdentifierTree tree) {
        return ((InternalSyntaxToken)tree.identifierToken()).getFromIndex() + tree.identifierToken().text().length();
    }
}

