/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.java.resolve.AnnotationInstance;
import org.sonar.java.resolve.BytecodeAnnotationVisitor;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;

public class BytecodeVisitor
extends ClassVisitor {
    private final Symbols symbols;
    private final Symbol.TypeSymbol classSymbol;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private BytecodeCompleter bytecodeCompleter;
    private String className;

    BytecodeVisitor(BytecodeCompleter bytecodeCompleter, Symbols symbols, Symbol.TypeSymbol classSymbol, ParametrizedTypeCache parametrizedTypeCache) {
        super(327680);
        this.bytecodeCompleter = bytecodeCompleter;
        this.symbols = symbols;
        this.classSymbol = classSymbol;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    private Symbol.TypeSymbol getClassSymbol(String bytecodeName) {
        return this.bytecodeCompleter.getClassSymbol(Convert.flatName(bytecodeName));
    }

    private Symbol.TypeSymbol getClassSymbol(String bytecodeName, int flags) {
        return this.bytecodeCompleter.getClassSymbol(Convert.flatName(bytecodeName), flags);
    }

    public void visit(int version, int flags, String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Preconditions.checkState((boolean)name.endsWith(this.classSymbol.name), (Object)("Name : '" + name + "' should ends with " + this.classSymbol.name));
        Preconditions.checkState((!BytecodeCompleter.isSynthetic(flags) ? 1 : 0) != 0, (Object)(name + " is synthetic"));
        this.className = name;
        if (signature != null) {
            SignatureReader signatureReader = new SignatureReader(signature);
            ReadGenericSignature readGenericSignature = new ReadGenericSignature();
            signatureReader.accept((SignatureVisitor)readGenericSignature);
            ((Type.ClassType)this.classSymbol.type).interfaces = readGenericSignature.interfaces();
        } else {
            if (superName == null) {
                Preconditions.checkState((boolean)"java/lang/Object".equals(this.className), (Object)("superName must be null only for java/lang/Object, but not for " + this.className));
            } else {
                ((Type.ClassType)this.classSymbol.type).supertype = this.getClassSymbol((String)superName).type;
            }
            ((Type.ClassType)this.classSymbol.type).interfaces = this.getCompletedClassSymbolsType(interfaces);
        }
        this.classSymbol.flags = (this.classSymbol.flags & 7) != 0 ? (this.classSymbol.flags |= this.bytecodeCompleter.filterBytecodeFlags(flags & 0xFFFFFFF8)) : (this.classSymbol.flags |= this.bytecodeCompleter.filterBytecodeFlags(flags));
        this.classSymbol.members = new Scope(this.classSymbol);
    }

    public void visitSource(@Nullable String source, @Nullable String debug) {
        throw new IllegalStateException();
    }

    public void visitOuterClass(String owner, String name, String desc) {
        throw new IllegalStateException();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type annotationType = this.convertAsmType(org.objectweb.asm.Type.getType((String)desc));
        AnnotationInstance annotationInstance = new AnnotationInstance(annotationType.getSymbol());
        this.classSymbol.metadata().addAnnotation(annotationInstance);
        return new BytecodeAnnotationVisitor(annotationInstance, this);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int flags) {
        if (!BytecodeCompleter.isSynthetic(flags) && innerName != null && outerName != null) {
            if (this.className.equals(outerName)) {
                this.defineInnerClass(name, flags);
            } else if (this.className.equals(name)) {
                this.defineOuterClass(outerName, innerName, flags);
            }
        }
    }

    private void defineInnerClass(String bytecodeName, int flags) {
        Symbol.TypeSymbol innerClass = this.getClassSymbol(bytecodeName, flags);
        innerClass.flags |= this.bytecodeCompleter.filterBytecodeFlags(flags);
        Preconditions.checkState((innerClass.owner == this.classSymbol ? 1 : 0) != 0, (Object)("Innerclass: " + innerClass.owner.getName() + " and classSymbol: " + this.classSymbol.getName() + " are not the same."));
        this.classSymbol.members.enter(innerClass);
    }

    private void defineOuterClass(String outerName, String innerName, int flags) {
        Symbol.TypeSymbol outerClassSymbol = this.getClassSymbol(outerName, flags);
        Preconditions.checkState((outerClassSymbol.completer == null || outerClassSymbol.completer instanceof BytecodeCompleter ? 1 : 0) != 0);
        this.classSymbol.name = innerName;
        this.classSymbol.owner = outerClassSymbol;
    }

    public FieldVisitor visitField(int flags, String name, String desc, @Nullable String signature, @Nullable Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)desc);
        if (!BytecodeCompleter.isSynthetic(flags)) {
            Symbol.VariableSymbol symbol = new Symbol.VariableSymbol(this.bytecodeCompleter.filterBytecodeFlags(flags), name, this.convertAsmType(org.objectweb.asm.Type.getType((String)desc)), (Symbol)this.classSymbol);
            this.classSymbol.members.enter(symbol);
            if (signature != null) {
                ReadType typeReader = new ReadType();
                new SignatureReader(signature).accept((SignatureVisitor)typeReader);
                symbol.type = typeReader.typeRead;
                symbol.isParametrized = symbol.type instanceof Type.TypeVariableType;
            }
        }
        return null;
    }

    public MethodVisitor visitMethod(int flags, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)desc);
        if (!BytecodeCompleter.isSynthetic(flags)) {
            Preconditions.checkState(((flags & 0x40) == 0 ? 1 : 0) != 0, (Object)("bridge method not marked as synthetic in class " + this.className));
            Type.MethodType type = new Type.MethodType(this.convertAsmTypes(org.objectweb.asm.Type.getArgumentTypes((String)desc)), this.convertAsmType(org.objectweb.asm.Type.getReturnType((String)desc)), this.getCompletedClassSymbolsType(exceptions), this.classSymbol);
            Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(this.bytecodeCompleter.filterBytecodeFlags(flags), name, type, (Symbol)this.classSymbol);
            this.classSymbol.members.enter(methodSymbol);
            if (signature != null) {
                new SignatureReader(signature).accept((SignatureVisitor)new ReadMethodSignature(methodSymbol));
            }
        }
        return null;
    }

    private List<Type> convertAsmTypes(org.objectweb.asm.Type[] asmTypes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (org.objectweb.asm.Type asmType : asmTypes) {
            result.add((Object)this.convertAsmType(asmType));
        }
        return result.build();
    }

    public Type convertAsmType(org.objectweb.asm.Type asmType) {
        Type result;
        switch (asmType.getSort()) {
            case 10: {
                result = this.getClassSymbol((String)asmType.getInternalName()).type;
                break;
            }
            case 3: {
                result = this.symbols.byteType;
                break;
            }
            case 2: {
                result = this.symbols.charType;
                break;
            }
            case 4: {
                result = this.symbols.shortType;
                break;
            }
            case 5: {
                result = this.symbols.intType;
                break;
            }
            case 7: {
                result = this.symbols.longType;
                break;
            }
            case 6: {
                result = this.symbols.floatType;
                break;
            }
            case 8: {
                result = this.symbols.doubleType;
                break;
            }
            case 1: {
                result = this.symbols.booleanType;
                break;
            }
            case 9: {
                result = new Type.ArrayType(this.convertAsmType(asmType.getElementType()), this.symbols.arrayClass);
                break;
            }
            case 0: {
                result = this.symbols.voidType;
                break;
            }
            default: {
                throw new IllegalArgumentException(asmType.toString());
            }
        }
        return result;
    }

    public void visitEnd() {
        if (this.classSymbol.owner == null) {
            String flatName = this.className.replace('/', '.');
            this.classSymbol.name = flatName.substring(flatName.lastIndexOf(46) + 1);
            this.classSymbol.owner = this.bytecodeCompleter.enterPackage(flatName);
            Symbol.PackageSymbol owner = (Symbol.PackageSymbol)this.classSymbol.owner;
            if (owner.members == null) {
                owner.members = new Scope(owner);
            }
            owner.members.enter(this.classSymbol);
        }
    }

    private List<Type> getCompletedClassSymbolsType(@Nullable String[] bytecodeNames) {
        if (bytecodeNames == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (String bytecodeName : bytecodeNames) {
            types.add((Object)this.getClassSymbol((String)bytecodeName).type);
        }
        return types.build();
    }

    private class ReadType
    extends SignatureVisitor {
        @Nullable
        private final Symbol.MethodSymbol methodSymbol;
        Type typeRead;
        List<Type> typeArguments;

        public ReadType() {
            super(327680);
            this.typeArguments = Lists.newArrayList();
            this.methodSymbol = null;
        }

        public ReadType(Symbol.MethodSymbol methodSymbol) {
            super(327680);
            this.typeArguments = Lists.newArrayList();
            this.methodSymbol = methodSymbol;
        }

        public void visitClassType(String name) {
            this.typeRead = ((BytecodeVisitor)BytecodeVisitor.this).getClassSymbol((String)name).type;
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadType.this.typeArguments.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitArrayType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadType.this.typeRead = new Type.ArrayType(this.typeRead, ((BytecodeVisitor)BytecodeVisitor.this).symbols.arrayClass);
                    ReadType.this.visitEnd();
                }
            };
        }

        public void visitBaseType(char descriptor) {
            this.typeRead = BytecodeVisitor.this.symbols.getPrimitiveFromDescriptor(descriptor);
            this.visitEnd();
        }

        public void visitTypeVariable(String name) {
            List<Object> lookup = Lists.newArrayList();
            Symbol currentSymbol = BytecodeVisitor.this.classSymbol;
            if (this.methodSymbol != null) {
                currentSymbol = this.methodSymbol;
            }
            while ((currentSymbol.isKind(2) || currentSymbol.isKind(16)) && lookup.isEmpty()) {
                if (currentSymbol.isKind(16)) {
                    lookup = ((Symbol.MethodSymbol)currentSymbol).typeParameters().lookup(name);
                } else if (currentSymbol.isKind(2)) {
                    lookup = ((Symbol.TypeSymbol)currentSymbol).typeParameters().lookup(name);
                }
                currentSymbol = currentSymbol.owner();
            }
            Preconditions.checkState((!lookup.isEmpty() ? 1 : 0) != 0, (Object)("Could not resolve type parameter: " + name + " in class " + BytecodeVisitor.this.classSymbol.getName()));
            Preconditions.checkState((lookup.size() == 1 ? 1 : 0) != 0, (Object)"More than one type parameter with the same name");
            this.typeRead = ((Symbol)lookup.get((int)0)).type;
            this.visitEnd();
        }

        public void visitEnd() {
            if (!this.typeArguments.isEmpty()) {
                Symbol.TypeSymbol readSymbol = this.typeRead.symbol;
                readSymbol.complete();
                if (this.typeArguments.size() == readSymbol.typeVariableTypes.size()) {
                    HashMap substitution = Maps.newHashMap();
                    int i = 0;
                    for (Type typeArgument : this.typeArguments) {
                        substitution.put(readSymbol.typeVariableTypes.get(i), typeArgument);
                        ++i;
                    }
                    this.typeRead = BytecodeVisitor.this.parametrizedTypeCache.getParametrizedTypeType(readSymbol, substitution);
                }
            }
        }
    }

    private class ReadMethodSignature
    extends SignatureVisitor {
        private final Symbol.MethodSymbol methodSymbol;
        Symbol.TypeVariableSymbol typeVariableSymbol;
        List<Type> bounds;

        public ReadMethodSignature(Symbol.MethodSymbol methodSymbol) {
            super(327680);
            this.methodSymbol = methodSymbol;
            ((Type.MethodType)methodSymbol.type).argTypes = Lists.newArrayList();
            ((Type.MethodType)methodSymbol.type).thrown = Lists.newArrayList();
            methodSymbol.typeParameters = new Scope(methodSymbol);
        }

        public void visitFormalTypeParameter(String name) {
            this.typeVariableSymbol = new Symbol.TypeVariableSymbol(name, this.methodSymbol);
            this.methodSymbol.typeParameters.enter(this.typeVariableSymbol);
            this.methodSymbol.addTypeParameter((Type.TypeVariableType)this.typeVariableSymbol.type);
            this.bounds = Lists.newArrayList();
            ((Type.TypeVariableType)this.typeVariableSymbol.type).bounds = this.bounds;
            this.methodSymbol.isParametrized = true;
        }

        public SignatureVisitor visitClassBound() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadMethodSignature.this.bounds.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitInterfaceBound() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadMethodSignature.this.bounds.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitParameterType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((Type.MethodType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).argTypes.add(this.typeRead);
                }
            };
        }

        public SignatureVisitor visitReturnType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((Type.MethodType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).resultType = this.typeRead;
                    ((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.returnType = this.typeRead.symbol;
                }
            };
        }

        public SignatureVisitor visitExceptionType() {
            return new ReadType(this.methodSymbol){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((Type.MethodType)((ReadMethodSignature)ReadMethodSignature.this).methodSymbol.type).thrown.add(this.typeRead);
                }
            };
        }

        public void visitEnd() {
            if (this.typeVariableSymbol != null) {
                if (this.bounds.isEmpty()) {
                    this.bounds.add(((BytecodeVisitor)BytecodeVisitor.this).symbols.objectType);
                }
                this.typeVariableSymbol = null;
                this.bounds = null;
            }
        }
    }

    private class ReadGenericSignature
    extends SignatureVisitor {
        Symbol.TypeVariableSymbol typeVariableSymbol;
        List<Type> bounds;
        ImmutableList.Builder<Type> interfaces;

        public ReadGenericSignature() {
            super(327680);
            this.interfaces = ImmutableList.builder();
        }

        public void visitFormalTypeParameter(String name) {
            this.typeVariableSymbol = new Symbol.TypeVariableSymbol(name, BytecodeVisitor.this.classSymbol);
            ((BytecodeVisitor)BytecodeVisitor.this).classSymbol.typeParameters.enter(this.typeVariableSymbol);
            BytecodeVisitor.this.classSymbol.addTypeParameter((Type.TypeVariableType)this.typeVariableSymbol.type);
            this.bounds = Lists.newArrayList();
            ((Type.TypeVariableType)this.typeVariableSymbol.type).bounds = this.bounds;
            ((BytecodeVisitor)BytecodeVisitor.this).classSymbol.isParametrized = true;
        }

        public SignatureVisitor visitSuperclass() {
            return new ReadType(){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ((Type.ClassType)((BytecodeVisitor)BytecodeVisitor.this).classSymbol.type).supertype = this.typeRead;
                }
            };
        }

        public SignatureVisitor visitInterface() {
            return new ReadType(){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    ReadGenericSignature.this.interfaces.add((Object)this.typeRead);
                }
            };
        }

        public void visitClassType(String name) {
            if (this.bounds != null) {
                this.bounds.add(((BytecodeVisitor)BytecodeVisitor.this).getClassSymbol((String)name).type);
            }
        }

        public void visitEnd() {
            if (this.typeVariableSymbol != null) {
                if (this.bounds.isEmpty()) {
                    this.bounds.add(((BytecodeVisitor)BytecodeVisitor.this).symbols.objectType);
                }
                this.typeVariableSymbol = null;
                this.bounds = null;
            }
        }

        public List<Type> interfaces() {
            return this.interfaces.build();
        }
    }
}

