/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;
import org.sonar.java.resolve.Types;

public class Resolve {
    private final SymbolNotFound symbolNotFound = new SymbolNotFound();
    private final BytecodeCompleter bytecodeCompleter;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Types types = new Types();
    private final Symbols symbols;

    public Resolve(Symbols symbols, BytecodeCompleter bytecodeCompleter, ParametrizedTypeCache parametrizedTypeCache) {
        this.symbols = symbols;
        this.bytecodeCompleter = bytecodeCompleter;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    private static Symbol.TypeSymbol superclassSymbol(Symbol.TypeSymbol c) {
        Type supertype = c.getSuperclass();
        return supertype == null ? null : supertype.symbol;
    }

    public Symbol.TypeSymbol registerClass(Symbol.TypeSymbol classSymbol) {
        return this.bytecodeCompleter.registerClass(classSymbol);
    }

    public Scope createStarImportScope(Symbol owner) {
        return new Scope.StarImportScope(owner, this.bytecodeCompleter);
    }

    public Scope createStaticStarImportScope(Symbol owner) {
        return new Scope.StaticStarImportScope(owner, this.bytecodeCompleter);
    }

    public Type resolveTypeSubstitution(Type type, Type definition) {
        if (definition instanceof Type.ParametrizedTypeType) {
            return this.substituteTypeParameter(type, ((Type.ParametrizedTypeType)definition).typeSubstitution);
        }
        return type;
    }

    private Type substituteTypeParameter(Type type, Map<Type.TypeVariableType, Type> substitution) {
        if (substitution.get(type) != null) {
            return substitution.get(type);
        }
        if (type instanceof Type.ParametrizedTypeType) {
            Type.ParametrizedTypeType ptt = (Type.ParametrizedTypeType)type;
            HashMap newSubstitution = Maps.newHashMap();
            for (Map.Entry<Type.TypeVariableType, Type> entry : ptt.typeSubstitution.entrySet()) {
                newSubstitution.put(entry.getKey(), this.substituteTypeParameter(entry.getValue(), substitution));
            }
            return this.parametrizedTypeCache.getParametrizedTypeType(ptt.rawType.getSymbol(), newSubstitution);
        }
        return type;
    }

    private Resolution findField(Env env, Symbol.TypeSymbol site, String name, Symbol.TypeSymbol c) {
        Resolution bestSoFar = this.unresolved();
        Resolution resolution = new Resolution();
        for (Symbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 4) continue;
            if (this.isAccessible(env, site, symbol)) {
                resolution.symbol = symbol;
                resolution.type = this.resolveTypeSubstitution(symbol.type, c.type);
                return resolution;
            }
            return Resolution.resolution(new AccessErrorSymbol(symbol, this.symbols.unknownType));
        }
        if (c.getSuperclass() != null) {
            resolution = this.findField(env, site, name, c.getSuperclass().symbol);
            if (((Resolution)resolution).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                resolution.type = this.resolveTypeSubstitution(((Resolution)resolution).symbol.type, c.getSuperclass());
                bestSoFar = resolution;
            }
        }
        for (Type interfaceType : c.getInterfaces()) {
            resolution = this.findField(env, site, name, interfaceType.symbol);
            if (((Resolution)resolution).symbol.kind >= ((Resolution)bestSoFar).symbol.kind) continue;
            bestSoFar = resolution;
        }
        return bestSoFar;
    }

    private Resolution findVar(Env env, String name) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer() != null) {
            Resolution sym = new Resolution();
            for (Symbol symbol : env1.scope().lookup(name)) {
                if (symbol.kind != 4) continue;
                sym.symbol = symbol;
            }
            if (sym.symbol == null) {
                sym = this.findField(env1, env1.enclosingClass(), name, env1.enclosingClass());
            }
            if (((Resolution)sym).symbol.kind < 64) {
                return sym;
            }
            if (((Resolution)sym).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = sym;
            }
            env1 = env1.outer();
        }
        Symbol symbol = this.findInStaticImport(env, name, 4);
        if (symbol.kind < 64) {
            return Resolution.resolution(symbol);
        }
        if (symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(symbol);
        }
        return bestSoFar;
    }

    private Symbol findInStaticImport(Env env, String name, int kind) {
        SymbolNotFound bestSoFar = this.symbolNotFound;
        for (Symbol symbol : env.namedImports().lookup(name)) {
            if ((kind & symbol.kind) == 0) continue;
            return symbol;
        }
        for (Symbol symbol : env.staticStarImports().lookup(name)) {
            if ((kind & symbol.kind) == 0) continue;
            return symbol;
        }
        return bestSoFar;
    }

    private Symbol findMemberType(Env env, Symbol.TypeSymbol site, String name, Symbol.TypeSymbol c) {
        Symbol bestSoFar = this.symbolNotFound;
        for (Symbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return this.isAccessible(env, site, symbol) ? symbol : new AccessErrorSymbol(symbol, this.symbols.unknownType);
        }
        if (c.getSuperclass() != null) {
            Symbol symbol = this.findMemberType(env, site, name, c.getSuperclass().symbol);
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        for (Type interfaceType : c.getInterfaces()) {
            Symbol symbol = this.findMemberType(env, site, name, interfaceType.symbol);
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        return bestSoFar;
    }

    private Symbol findType(Env env, String name) {
        Symbol bestSoFar = this.symbolNotFound;
        for (Env env1 = env; env1 != null; env1 = env1.outer()) {
            for (Symbol symbol : env1.scope().lookup(name)) {
                if (symbol.kind != 2) continue;
                return symbol;
            }
            if (env1.outer == null) continue;
            Symbol symbol = this.findMemberType(env1, env1.enclosingClass(), name, env1.enclosingClass());
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        Symbol predefinedSymbol = this.findMemberType(env, this.symbols.predefClass, name, this.symbols.predefClass);
        if (predefinedSymbol.kind < bestSoFar.kind) {
            return predefinedSymbol;
        }
        for (Symbol symbol : env.namedImports().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        Symbol sym = this.findIdentInPackage(env.packge(), name, 2);
        if (sym.kind < bestSoFar.kind) {
            return sym;
        }
        for (Symbol symbol : env.starImports().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        Symbol.PackageSymbol javaLang = this.bytecodeCompleter.enterPackage("java.lang");
        for (Symbol symbol : javaLang.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        return bestSoFar;
    }

    public Resolution findIdent(Env env, String name, int kind) {
        Resolution res;
        Resolution bestSoFar = this.unresolved();
        if ((kind & 4) != 0) {
            res = this.findVar(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 2) != 0) {
            res = new Resolution();
            res.symbol = this.findType(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 1) != 0) {
            res = new Resolution();
            res.symbol = this.findIdentInPackage(this.symbols.defaultPackage, name, 1);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        return bestSoFar;
    }

    public Symbol findIdentInPackage(Symbol site, String name, int kind) {
        String fullname = this.bytecodeCompleter.formFullName(name, site);
        Symbol bestSoFar = this.symbolNotFound;
        if ((kind & 2) != 0) {
            Symbol sym = this.bytecodeCompleter.loadClass(fullname);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0 && bestSoFar.kind >= this.symbolNotFound.kind) {
            bestSoFar = this.bytecodeCompleter.enterPackage(fullname);
        }
        return bestSoFar;
    }

    public Symbol findIdentInType(Env env, Symbol.TypeSymbol site, String name, int kind) {
        Symbol symbol;
        Symbol bestSoFar = this.symbolNotFound;
        if ((kind & 4) != 0) {
            symbol = this.findField(env, site, name, site).symbol;
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if ((kind & 2) != 0) {
            symbol = this.findMemberType(env, site, name, site);
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, String name, List<Type> argTypes, List<Type> typeParamTypes) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer() != null) {
            Resolution res = this.findMethod(env1, env1.enclosingClass().getType(), name, argTypes, typeParamTypes);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
            env1 = env1.outer;
        }
        Symbol sym = this.findInStaticImport(env, name, 16);
        if (sym.kind < 64) {
            return Resolution.resolution(sym);
        }
        if (sym.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(sym);
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, Type site, String name, List<Type> argTypes) {
        return this.findMethod(env, site, name, argTypes, (List<Type>)ImmutableList.of(), false);
    }

    public Resolution findMethod(Env env, Type site, String name, List<Type> argTypes, List<Type> typeParams) {
        return this.findMethod(env, site, name, argTypes, typeParams, false);
    }

    private Resolution findMethod(Env env, Type site, String name, List<Type> argTypes, List<Type> typeParams, boolean autoboxing) {
        Resolution bestSoFar = this.unresolved();
        for (Symbol symbol : site.getSymbol().members().lookup(name)) {
            Symbol best;
            if (symbol.kind != 16 || (best = this.selectBest(env, site.getSymbol(), argTypes, symbol, bestSoFar.symbol, autoboxing)) != symbol) continue;
            bestSoFar = Resolution.resolution(best);
            bestSoFar.type = this.resolveTypeSubstitution(((Type.MethodType)best.type).resultType, site);
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)best;
            bestSoFar.type = this.handleTypeArguments(typeParams, bestSoFar.type, methodSymbol);
        }
        if (site.getSymbol().getSuperclass() != null) {
            Resolution method = this.findMethod(env, site.getSymbol().getSuperclass(), name, argTypes, typeParams);
            Symbol best = this.selectBest(env, site.getSymbol(), argTypes, method.symbol, bestSoFar.symbol, autoboxing);
            if (best == method.symbol) {
                bestSoFar = method;
            }
        }
        for (Type interfaceType : site.getSymbol().getInterfaces()) {
            Resolution method = this.findMethod(env, interfaceType, name, argTypes, typeParams);
            Symbol best = this.selectBest(env, site.getSymbol(), argTypes, method.symbol, bestSoFar.symbol, autoboxing);
            if (best != method.symbol) continue;
            bestSoFar = method;
        }
        if (((Resolution)bestSoFar).symbol.kind >= 64 && !autoboxing) {
            bestSoFar = this.findMethod(env, site, name, argTypes, typeParams, true);
        }
        return bestSoFar;
    }

    private Type handleTypeArguments(List<Type> typeParams, Type type, Symbol.MethodSymbol methodSymbol) {
        if (!typeParams.isEmpty() && methodSymbol.typeVariableTypes.size() == typeParams.size()) {
            HashMap substitution = Maps.newHashMap();
            int i = 0;
            for (Type.TypeVariableType typeVariableType : methodSymbol.typeVariableTypes) {
                substitution.put(typeVariableType, typeParams.get(i));
                ++i;
            }
            return this.substituteTypeParameter(type, substitution);
        }
        return type;
    }

    private Symbol selectBest(Env env, Symbol.TypeSymbol site, List<Type> argTypes, Symbol symbol, Symbol bestSoFar, boolean autoboxing) {
        if (symbol.kind >= 64 || !this.isInheritedIn(symbol, site) || symbol.type == null) {
            return bestSoFar;
        }
        boolean isVarArgs = ((Symbol.MethodSymbol)symbol).isVarArgs();
        if (!this.isArgumentsAcceptable(argTypes, ((Type.MethodType)symbol.type).argTypes, isVarArgs, autoboxing)) {
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, symbol)) {
            return new AccessErrorSymbol(symbol, this.symbols.unknownType);
        }
        Symbol mostSpecific = this.selectMostSpecific(symbol, bestSoFar, argTypes);
        if (mostSpecific.isKind(65)) {
            mostSpecific = bestSoFar;
        }
        return mostSpecific;
    }

    private boolean isArgumentsAcceptable(List<Type> argTypes, List<Type> formals, boolean isVarArgs, boolean autoboxing) {
        int i;
        int argsSize = argTypes.size();
        int formalsSize = formals.size();
        int nbArgToCheck = argsSize - formalsSize;
        if (isVarArgs ? ++nbArgToCheck < 0 : nbArgToCheck != 0) {
            return false;
        }
        for (i = 1; i <= nbArgToCheck; ++i) {
            Type.ArrayType lastFormal = (Type.ArrayType)formals.get(formalsSize - 1);
            Type argType = argTypes.get(argsSize - i);
            if (this.isAcceptableType(argType, lastFormal.elementType, autoboxing) || nbArgToCheck == 1 && this.types.isSubtype(argType, lastFormal)) continue;
            return false;
        }
        for (i = 0; i < argsSize - nbArgToCheck; ++i) {
            if (this.isAcceptableType(argTypes.get(i), formals.get(i), autoboxing)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptableType(Type arg, Type formal, boolean autoboxing) {
        return this.types.isSubtype(arg.erasure(), formal.erasure()) || autoboxing && this.isAcceptableByAutoboxing(arg, formal);
    }

    private boolean isAcceptableByAutoboxing(Type expressionType, Type formalType) {
        if (expressionType.isPrimitive()) {
            return this.types.isSubtype((Type)this.symbols.boxedTypes.get((Object)expressionType), formalType);
        }
        Type unboxedType = (Type)this.symbols.boxedTypes.inverse().get((Object)expressionType);
        if (unboxedType != null) {
            return this.types.isSubtype(unboxedType, formalType);
        }
        return false;
    }

    private Symbol selectMostSpecific(Symbol m1, Symbol m2, List<Type> argTypes) {
        if (m2.type == null || !m2.isKind(16)) {
            return m1;
        }
        boolean m1SignatureMoreSpecific = this.isSignatureMoreSpecific(m1, m2);
        boolean m2SignatureMoreSpecific = this.isSignatureMoreSpecific(m2, m1);
        if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
            return new AmbiguityErrorSymbol();
        }
        if (m1SignatureMoreSpecific) {
            return m1;
        }
        if (m2SignatureMoreSpecific) {
            return m2;
        }
        return new AmbiguityErrorSymbol();
    }

    private boolean isSignatureMoreSpecific(Symbol m1, Symbol m2) {
        return this.isArgumentsAcceptable(((Type.MethodType)m1.type).argTypes, ((Type.MethodType)m2.type).argTypes, false, false);
    }

    @VisibleForTesting
    boolean isAccessible(Env env, Symbol.TypeSymbol c) {
        boolean result;
        switch (c.flags() & 7) {
            case 2: {
                result = env.enclosingClass().outermostClass() == c.owner().outermostClass();
                break;
            }
            case 0: {
                result = env.packge() == c.packge();
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 4: {
                result = env.packge() == c.packge() || this.isInnerSubClass(env.enclosingClass(), c.owner());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private boolean isInnerSubClass(Symbol.TypeSymbol c, Symbol base) {
        while (c != null && this.isSubClass(c, base)) {
            c = c.owner().enclosingClass();
        }
        return c != null;
    }

    @VisibleForTesting
    boolean isSubClass(Symbol.TypeSymbol c, Symbol base) {
        if (c == null) {
            return false;
        }
        if (c == base) {
            return true;
        }
        if ((base.flags() & 0x200) != 0) {
            for (Type interfaceType : c.getInterfaces()) {
                if (!this.isSubClass(interfaceType.symbol, base)) continue;
                return true;
            }
            return this.isSubClass(Resolve.superclassSymbol(c), base);
        }
        return this.isSubClass(Resolve.superclassSymbol(c), base);
    }

    private boolean isAccessible(Env env, Symbol.TypeSymbol site, Symbol symbol) {
        switch (symbol.flags() & 7) {
            case 2: {
                return env.enclosingClass != null && env.enclosingClass().outermostClass() == symbol.owner().outermostClass() && this.isInheritedIn(symbol, site);
            }
            case 0: {
                return env.packge() == symbol.packge() && this.isAccessible(env, site) && this.isInheritedIn(symbol, site) && this.notOverriddenIn(site, symbol);
            }
            case 1: {
                return this.isAccessible(env, site) && this.notOverriddenIn(site, symbol);
            }
            case 4: {
                return (env.packge() == symbol.packge() || this.isProtectedAccessible(symbol, env.enclosingClass, site)) && this.isAccessible(env, site) && this.notOverriddenIn(site, symbol);
            }
        }
        throw new IllegalStateException();
    }

    private boolean notOverriddenIn(Symbol.TypeSymbol site, Symbol symbol) {
        return true;
    }

    @VisibleForTesting
    boolean isInheritedIn(Symbol symbol, Symbol.TypeSymbol clazz) {
        switch (symbol.flags() & 7) {
            case 1: {
                return true;
            }
            case 2: {
                return symbol.owner() == clazz;
            }
            case 4: {
                return true;
            }
            case 0: {
                Symbol.PackageSymbol thisPackage = symbol.packge();
                Symbol.TypeSymbol sup = clazz;
                while (sup != null && sup != symbol.owner()) {
                    if (sup.packge() != thisPackage) {
                        return false;
                    }
                    sup = Resolve.superclassSymbol(sup);
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean isProtectedAccessible(Symbol symbol, Symbol.TypeSymbol c, Symbol.TypeSymbol site) {
        return true;
    }

    private Resolution unresolved() {
        Resolution resolution = new Resolution(this.symbolNotFound);
        resolution.type = this.symbols.unknownType;
        return resolution;
    }

    public static class AccessErrorSymbol
    extends Symbol {
        Symbol symbol;

        public AccessErrorSymbol(Symbol symbol, Type type) {
            super(64, 0, null, null);
            this.symbol = symbol;
            this.type = type;
        }
    }

    public static class AmbiguityErrorSymbol
    extends Symbol {
        public AmbiguityErrorSymbol() {
            super(65, 0, null, null);
        }
    }

    public static class SymbolNotFound
    extends Symbol {
        public SymbolNotFound() {
            super(66, 0, null, null);
        }
    }

    static class Env {
        Env next;
        Env outer;
        Symbol.PackageSymbol packge;
        Symbol.TypeSymbol enclosingClass;
        Scope scope;
        Scope namedImports;
        Scope starImports;
        Scope staticStarImports;

        Env() {
        }

        Env outer() {
            return this.outer;
        }

        Symbol.TypeSymbol enclosingClass() {
            return this.enclosingClass;
        }

        public Symbol.PackageSymbol packge() {
            return this.packge;
        }

        Scope namedImports() {
            return this.namedImports;
        }

        Scope starImports() {
            return this.starImports;
        }

        public Scope staticStarImports() {
            return this.staticStarImports;
        }

        Scope scope() {
            return this.scope;
        }

        public Env dup() {
            Env env = new Env();
            env.next = this;
            env.outer = this.outer;
            env.packge = this.packge;
            env.enclosingClass = this.enclosingClass;
            env.scope = this.scope;
            env.namedImports = this.namedImports;
            env.starImports = this.starImports;
            env.staticStarImports = this.staticStarImports;
            return env;
        }
    }

    static class Resolution {
        private Symbol symbol;
        private Type type;

        private Resolution(Symbol symbol) {
            this.symbol = symbol;
        }

        Resolution() {
        }

        static Resolution resolution(Symbol symbol) {
            return new Resolution(symbol);
        }

        Symbol symbol() {
            return this.symbol;
        }

        public Type type() {
            if (this.type == null) {
                if (this.symbol.isKind(16)) {
                    return ((Type.MethodType)this.symbol.type).resultType;
                }
                return this.symbol.type;
            }
            return this.type;
        }
    }
}

