/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.java.ast.visitors.AccessorVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ComplexityVisitor
extends SubscriptionVisitor {
    private int complexity;
    private AccessorVisitor accessorVisitor = new AccessorVisitor();
    private Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private boolean analyseAccessors;

    public ComplexityVisitor(boolean analyseAccessors) {
        this.analyseAccessors = analyseAccessors;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.METHOD).add((Object)Tree.Kind.CONSTRUCTOR).add((Object)Tree.Kind.IF_STATEMENT).add((Object)Tree.Kind.FOR_STATEMENT).add((Object)Tree.Kind.FOR_EACH_STATEMENT).add((Object)Tree.Kind.DO_STATEMENT).add((Object)Tree.Kind.WHILE_STATEMENT).add((Object)Tree.Kind.RETURN_STATEMENT).add((Object)Tree.Kind.THROW_STATEMENT).add((Object)Tree.Kind.CASE_LABEL).add((Object)Tree.Kind.CATCH).add((Object)Tree.Kind.CONDITIONAL_EXPRESSION).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).add((Object)Tree.Kind.CLASS).add((Object)Tree.Kind.ENUM).add((Object)Tree.Kind.ANNOTATION_TYPE).build();
    }

    public int scan(ClassTree classTree, MethodTree tree) {
        this.complexity = 0;
        this.classTrees.clear();
        this.classTrees.push(classTree);
        super.scanTree(tree);
        return this.complexity;
    }

    public int scan(Tree tree) {
        this.complexity = 0;
        this.classTrees.clear();
        super.scanTree(tree);
        return this.complexity;
    }

    @Override
    public void visitNode(Tree tree) {
        if (this.isClass(tree)) {
            this.classTrees.push((ClassTree)tree);
        } else if (this.isMethod(tree)) {
            this.computeMethodComplexity((MethodTree)tree);
        } else if (tree.is(Tree.Kind.CASE_LABEL)) {
            CaseLabelTree caseLabelTree = (CaseLabelTree)tree;
            if (!"default".equals(caseLabelTree.caseOrDefaultKeyword().text())) {
                ++this.complexity;
            }
        } else {
            ++this.complexity;
        }
    }

    private boolean isMethod(Tree tree) {
        return tree.is(Tree.Kind.METHOD) || tree.is(Tree.Kind.CONSTRUCTOR);
    }

    private boolean isClass(Tree tree) {
        return tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.ENUM) || tree.is(Tree.Kind.ANNOTATION_TYPE);
    }

    private void computeMethodComplexity(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null) {
            if (this.classTrees.isEmpty() || !this.isAccessor(methodTree)) {
                ++this.complexity;
            }
            if (!block.body().isEmpty() && ((StatementTree)Iterables.getLast(block.body())).is(Tree.Kind.RETURN_STATEMENT)) {
                --this.complexity;
            }
        }
    }

    private boolean isAccessor(MethodTree methodTree) {
        return this.analyseAccessors && this.accessorVisitor.isAccessor(this.classTrees.peek(), methodTree);
    }

    @Override
    public void leaveNode(Tree tree) {
        if (this.isClass(tree)) {
            this.classTrees.pop();
        }
    }
}

