/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BreakStatementTreeImpl
extends JavaTree
implements BreakStatementTree {
    @Nullable
    private final IdentifierTree label;

    public BreakStatementTreeImpl(@Nullable IdentifierTree label, AstNode ... children) {
        super(Tree.Kind.BREAK_STATEMENT);
        this.label = label;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BREAK_STATEMENT;
    }

    @Override
    public SyntaxToken breakKeyword() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaKeyword.BREAK}));
    }

    @Override
    @Nullable
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public SyntaxToken semicolonToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.SEMI}));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBreakStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.label);
    }
}

