/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.sonar.java.resolve.AnnotationInstance;
import org.sonar.java.resolve.AnnotationValue;
import org.sonar.java.resolve.BytecodeVisitor;
import org.sonar.java.resolve.Symbol;

public class BytecodeAnnotationVisitor
extends AnnotationVisitor {
    private final AnnotationInstance annotationInstance;
    private final BytecodeVisitor bytecodeVisitor;

    public BytecodeAnnotationVisitor(AnnotationInstance annotationInstance, BytecodeVisitor bytecodeVisitor) {
        super(327680);
        this.annotationInstance = annotationInstance;
        this.bytecodeVisitor = bytecodeVisitor;
    }

    private void addValue(String name, Object value) {
        this.annotationInstance.addValue(new AnnotationValue(name, value));
    }

    public void visit(String name, Object value) {
        this.addValue(name, value);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        Symbol.TypeSymbol annotationSymbol = this.getSymbol(desc);
        AnnotationInstance paramAnnotation = new AnnotationInstance(annotationSymbol);
        return new BytecodeAnnotationVisitor(paramAnnotation, this.bytecodeVisitor);
    }

    public void visitEnum(String name, String desc, String value) {
        List<Symbol> lookup = this.getSymbol(desc).members().lookup(value);
        for (Symbol symbol : lookup) {
            if (!symbol.isKind(4)) continue;
            this.addValue(name, symbol);
        }
    }

    public AnnotationVisitor visitArray(final String name) {
        final ArrayList valuesList = Lists.newArrayList();
        return new AnnotationVisitor(327680, this){

            public void visit(String name2, Object value) {
                valuesList.add(value);
            }

            public void visitEnd() {
                BytecodeAnnotationVisitor.this.addValue(name, valuesList.toArray());
            }
        };
    }

    private Symbol.TypeSymbol getSymbol(String desc) {
        return this.bytecodeVisitor.convertAsmType(Type.getType((String)desc)).getSymbol();
    }
}

