/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.signature;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.MethodSignature;
import org.sonar.java.signature.Parameter;
import org.sonar.java.signature.ParameterSignatureScanner;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class MethodSignatureScanner {
    private final String bytecodeMethodSignature;
    private final MethodTree methodTree;
    private static final BiMap<String, JvmJavaType> JAVA_TYPE_MAPPING = HashBiMap.create();

    public MethodSignatureScanner(MethodTree methodTree) {
        this.methodTree = methodTree;
        this.bytecodeMethodSignature = null;
    }

    public static MethodSignature scan(MethodTree methodTree) {
        MethodSignatureScanner scanner = new MethodSignatureScanner(methodTree);
        return scanner.scanTree();
    }

    public static String getReadableType(JvmJavaType jvmJavaType) {
        return (String)JAVA_TYPE_MAPPING.inverse().get((Object)jvmJavaType);
    }

    private MethodSignature scanTree() {
        Parameter returnTypeParam;
        String name = this.methodTree.simpleName().name();
        if (this.methodTree.is(Tree.Kind.CONSTRUCTOR)) {
            name = "<init>";
            returnTypeParam = new Parameter(JvmJavaType.V, false);
        } else {
            returnTypeParam = this.getParameter(this.methodTree.returnType());
        }
        ArrayList argumentTypes = Lists.newArrayList();
        for (VariableTree variableTree : this.methodTree.parameters()) {
            argumentTypes.add(this.getParameter(variableTree.type()));
        }
        return new MethodSignature(name, returnTypeParam, argumentTypes);
    }

    private Parameter getParameter(Tree typeTree) {
        JvmJavaType jvmType;
        boolean isArray = false;
        Tree type = typeTree;
        if (type.is(Tree.Kind.ARRAY_TYPE)) {
            isArray = true;
            while (type.is(Tree.Kind.ARRAY_TYPE)) {
                type = ((ArrayTypeTree)type).type();
            }
        }
        Parameter parameter = (jvmType = this.jvmJavaTypeOf(type)).equals((Object)JvmJavaType.L) ? new Parameter(this.getTypeName(type), isArray) : new Parameter(jvmType, isArray);
        return parameter;
    }

    private String getTypeName(Tree typeTree) {
        if (typeTree.is(Tree.Kind.IDENTIFIER)) {
            return ((IdentifierTree)typeTree).name();
        }
        if (typeTree.is(Tree.Kind.MEMBER_SELECT)) {
            return ((MemberSelectExpressionTree)typeTree).identifier().name();
        }
        if (typeTree.is(Tree.Kind.PARAMETERIZED_TYPE)) {
            return this.getTypeName(((ParameterizedTypeTree)typeTree).type());
        }
        return "";
    }

    private JvmJavaType jvmJavaTypeOf(Tree type) {
        if (type.is(Tree.Kind.PRIMITIVE_TYPE)) {
            return (JvmJavaType)((Object)JAVA_TYPE_MAPPING.get((Object)((PrimitiveTypeTree)type).keyword().text()));
        }
        return JvmJavaType.L;
    }

    private MethodSignatureScanner(String bytecodeMethodSignature) {
        this.bytecodeMethodSignature = bytecodeMethodSignature;
        this.methodTree = null;
    }

    public static MethodSignature scan(String bytecodeMethodSignature) {
        Preconditions.checkNotNull((Object)bytecodeMethodSignature);
        MethodSignatureScanner scanner = new MethodSignatureScanner(bytecodeMethodSignature);
        return scanner.scan();
    }

    private MethodSignature scan() {
        int leftBracketIndex = this.bytecodeMethodSignature.indexOf(40);
        int rightBracketIndex = this.bytecodeMethodSignature.indexOf(41);
        String methodName = this.bytecodeMethodSignature.substring(0, leftBracketIndex);
        Parameter returnType = ParameterSignatureScanner.scan(this.bytecodeMethodSignature.substring(rightBracketIndex + 1));
        List<Parameter> argumentTypes = ParameterSignatureScanner.scanArguments(this.bytecodeMethodSignature.substring(leftBracketIndex + 1, rightBracketIndex));
        return new MethodSignature(methodName, returnType, argumentTypes);
    }

    static {
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.BYTE.getValue(), (Object)JvmJavaType.B);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.CHAR.getValue(), (Object)JvmJavaType.C);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.SHORT.getValue(), (Object)JvmJavaType.S);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.INT.getValue(), (Object)JvmJavaType.I);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.LONG.getValue(), (Object)JvmJavaType.J);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.BOOLEAN.getValue(), (Object)JvmJavaType.Z);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.FLOAT.getValue(), (Object)JvmJavaType.F);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.DOUBLE.getValue(), (Object)JvmJavaType.D);
        JAVA_TYPE_MAPPING.put((Object)JavaKeyword.VOID.getValue(), (Object)JvmJavaType.V);
    }
}

