/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.api.tree;

import com.google.common.annotations.Beta;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Beta
public class BaseTreeVisitor
implements TreeVisitor {
    protected void scan(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            this.scan(tree);
        }
    }

    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected void scan(@Nullable ListTree<? extends Tree> listTree) {
        this.scan((Tree)listTree);
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.scan(tree.packageAnnotations());
        this.scan(tree.packageName());
        this.scan(tree.imports());
        this.scan(tree.types());
    }

    @Override
    public void visitImport(ImportTree tree) {
        this.scan(tree.qualifiedIdentifier());
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.scan(tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.superClass());
        this.scan(tree.superInterfaces());
        this.scan(tree.members());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.scan(tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.returnType());
        this.scan(tree.parameters());
        this.scan(tree.defaultValue());
        this.scan(tree.throwsClauses());
        this.scan(tree.block());
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.scan(tree.body());
    }

    @Override
    public void visitEmptyStatement(EmptyStatementTree tree) {
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.scan(tree.label());
        this.scan(tree.statement());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.thenStatement());
        this.scan(tree.elseStatement());
    }

    @Override
    public void visitAssertStatement(AssertStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.detail());
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.cases());
    }

    @Override
    public void visitCaseGroup(CaseGroupTree tree) {
        this.scan(tree.labels());
        this.scan(tree.body());
    }

    @Override
    public void visitCaseLabel(CaseLabelTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan(tree.statement());
        this.scan(tree.condition());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.initializer());
        this.scan(tree.condition());
        this.scan(tree.update());
        this.scan(tree.statement());
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.scan(tree.variable());
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.scan(tree.label());
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.scan(tree.label());
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.block());
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        this.scan(tree.block());
        this.scan(tree.catches());
        this.scan(tree.finallyBlock());
    }

    @Override
    public void visitCatch(CatchTree tree) {
        this.scan(tree.parameter());
        this.scan(tree.block());
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.scan(tree.leftOperand());
        this.scan(tree.rightOperand());
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.scan(tree.condition());
        this.scan(tree.trueExpression());
        this.scan(tree.falseExpression());
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.scan(tree.expression());
        this.scan(tree.index());
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.scan(tree.expression());
        this.scan(tree.identifier());
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        this.scan(tree.enclosingExpression());
        this.scan(tree.identifier());
        this.scan(tree.typeArguments());
        this.scan(tree.arguments());
        this.scan(tree.classBody());
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.scan(tree.type());
        this.scan(tree.dimensions());
        this.scan(tree.initializers());
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.scan(tree.methodSelect());
        this.scan(tree.typeArguments());
        this.scan(tree.arguments());
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.scan(tree.type());
        this.scan(tree.expression());
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.scan(tree.expression());
        this.scan(tree.type());
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.scan(tree.variable());
        this.scan(tree.expression());
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.scan(tree.modifiers());
        this.scan(tree.type());
        this.scan(tree.initializer());
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        this.scan(tree.type());
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan(tree.modifiers());
        this.scan(tree.initializer());
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.scan(tree.type());
        this.scan(tree.typeArguments());
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        this.scan(tree.bound());
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.scan(tree.typeAlternatives());
    }

    @Override
    public void visitModifier(ModifiersTree modifiersTree) {
        this.scan(modifiersTree.annotations());
    }

    @Override
    public void visitAnnotation(AnnotationTree annotationTree) {
        this.scan(annotationTree.annotationType());
        this.scan(annotationTree.arguments());
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        this.scan(lambdaExpressionTree.parameters());
        this.scan(lambdaExpressionTree.body());
    }

    @Override
    public void visitTypeParameter(TypeParameterTree typeParameter) {
        this.scan(typeParameter.identifier());
        this.scan(typeParameter.bounds());
    }

    @Override
    public void visitTypeArguments(TypeArgumentListTreeImpl trees) {
        this.scan(trees);
    }

    @Override
    public void visitTypeParameters(TypeParameters trees) {
        this.scan(trees);
    }

    @Override
    public void visitOther(Tree tree) {
    }

    @Override
    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        this.scan(methodReferenceTree.expression());
        this.scan(methodReferenceTree.typeArguments());
        this.scan(methodReferenceTree.method());
    }
}

