/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.JavaSymbol;

public class Scope {
    final JavaSymbol owner;
    final Scope next;
    protected ArrayListMultimap<String, JavaSymbol> symbols = ArrayListMultimap.create();

    public Scope(JavaSymbol owner) {
        this.owner = owner;
        this.next = null;
    }

    public Scope(Scope next) {
        this.owner = next.owner;
        this.next = next;
    }

    public void enter(JavaSymbol symbol) {
        this.symbols.put((Object)symbol.name, (Object)symbol);
    }

    public List<JavaSymbol> lookup(String name) {
        Scope scope = this;
        while (scope != null && !scope.symbols.containsKey((Object)name)) {
            scope = scope.next;
        }
        return scope == null ? ImmutableList.of() : scope.symbols.get((Object)name);
    }

    public Collection<JavaSymbol> scopeSymbols() {
        return ImmutableList.copyOf((Collection)this.symbols.values());
    }

    public static class StaticStarImportScope
    extends Scope {
        private final BytecodeCompleter bytecodeCompleter;

        public StaticStarImportScope(JavaSymbol owner, BytecodeCompleter bytecodeCompleter) {
            super(owner);
            this.bytecodeCompleter = bytecodeCompleter;
        }

        @Override
        public List<JavaSymbol> lookup(String name) {
            ArrayList symbolsList = Lists.newArrayList();
            for (JavaSymbol site : this.symbols.values()) {
                if ((site.kind & 1) != 0) {
                    JavaSymbol symbol = this.bytecodeCompleter.loadClass(this.bytecodeCompleter.formFullName(name, site));
                    if (symbol.kind < 64) {
                        symbolsList.add(symbol);
                    }
                }
                if ((site.kind & 2) == 0) continue;
                List<JavaSymbol> resolved = ((JavaSymbol.TypeJavaSymbol)site).members().lookup(name);
                for (JavaSymbol symbol : resolved) {
                    if (symbol.kind >= 64 || (symbol.flags & 8) == 0) continue;
                    symbolsList.add(symbol);
                }
            }
            return symbolsList;
        }
    }

    public static class StarImportScope
    extends Scope {
        private final BytecodeCompleter bytecodeCompleter;

        public StarImportScope(JavaSymbol owner, BytecodeCompleter bytecodeCompleter) {
            super(owner);
            this.bytecodeCompleter = bytecodeCompleter;
        }

        @Override
        public List<JavaSymbol> lookup(String name) {
            ArrayList symbolsList = Lists.newArrayList();
            for (JavaSymbol site : this.symbols.values()) {
                JavaSymbol symbol = this.bytecodeCompleter.loadClass(this.bytecodeCompleter.formFullName(name, site));
                if (symbol.kind >= 64) continue;
                symbolsList.add(symbol);
            }
            return symbolsList;
        }
    }

    public static class OrderedScope
    extends Scope {
        private List<JavaSymbol> orderedSymbols = Lists.newArrayList();

        public OrderedScope(JavaSymbol owner) {
            super(owner);
        }

        @Override
        public void enter(JavaSymbol symbol) {
            this.orderedSymbols.add(symbol);
            super.enter(symbol);
        }

        public List<JavaSymbol> scopeSymbols() {
            return ImmutableList.copyOf(this.orderedSymbols);
        }
    }
}

