/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.sonar.java.resolve.JavaType;

public class Types {
    public boolean isSubtype(JavaType t, JavaType s) {
        boolean result;
        if (t == s) {
            result = true;
        } else {
            switch (t.tag) {
                case 1: 
                case 2: {
                    result = t.tag == s.tag || t.tag + 2 <= s.tag && s.tag <= 7;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    result = t.tag <= s.tag && s.tag <= 7;
                    break;
                }
                case 8: 
                case 9: {
                    result = t.tag == s.tag;
                    break;
                }
                case 11: {
                    if (t.tag != s.tag) {
                        result = t.getSymbol().getSuperclass() == s;
                        break;
                    }
                    result = this.isSubtype(((JavaType.ArrayJavaType)t).elementType(), ((JavaType.ArrayJavaType)s).elementType());
                    break;
                }
                case 10: {
                    if (t.tag != s.tag) {
                        result = false;
                        break;
                    }
                    HashSet erasedTypes = Sets.newHashSet();
                    for (JavaType.ClassJavaType classType : t.getSymbol().superTypes()) {
                        erasedTypes.add(classType.erasure());
                    }
                    result = erasedTypes.contains(s);
                    break;
                }
                case 13: {
                    result = s.tag == 13 || s.tag == 10 || s.tag == 11;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }
}

