/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.source.Highlightable;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaTestClasspath;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.api.CodeVisitor;

public class SonarComponents
implements BatchExtension {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final JavaTestClasspath javaTestClasspath;
    private final CheckFactory checkFactory;
    private final JavaClasspath javaClasspath;
    private final Project project;
    private final List<Checks<JavaCheck>> checks;
    private Checks<JavaCheck> testChecks;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, Project project, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory) {
        this(fileLinesContextFactory, resourcePerspectives, project, javaClasspath, javaTestClasspath, checkFactory, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, Project project, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, @Nullable CheckRegistrar[] checkRegistrars) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.project = project;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.checks = Lists.newArrayList();
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                this.registerCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList(registrarContext.checkClasses()));
            }
        }
    }

    public Resource resourceFromIOFile(File file) {
        return org.sonar.api.resources.File.fromIOFile((File)file, (Project)this.project);
    }

    public FileLinesContext fileLinesContextFor(File file) {
        return this.fileLinesContextFactory.createFor(this.resourceFromIOFile(file));
    }

    public Symbolizable symbolizableFor(File file) {
        return (Symbolizable)this.resourcePerspectives.as(Symbolizable.class, this.resourceFromIOFile(file));
    }

    public Highlightable highlightableFor(File file) {
        return (Highlightable)this.resourcePerspectives.as(Highlightable.class, this.resourceFromIOFile(file));
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return Lists.newArrayList();
        }
        return this.javaClasspath.getElements();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public ResourcePerspectives getResourcePerspectives() {
        return this.resourcePerspectives;
    }

    public void registerCheckClasses(String repositoryKey, Collection<Class<? extends JavaCheck>> checkClasses) {
        this.checks.add((Checks<JavaCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses));
    }

    public CodeVisitor[] checkClasses() {
        ArrayList visitors = Lists.newArrayList();
        for (Checks<JavaCheck> check : this.checks) {
            visitors.addAll(check.all());
        }
        return visitors.toArray(new CodeVisitor[visitors.size()]);
    }

    public Iterable<Checks<JavaCheck>> checks() {
        return Iterables.concat(this.checks, (Iterable)Lists.newArrayList((Object[])new Checks[]{this.testChecks}));
    }

    public void registerTestCheckClasses(String repositoryKey, List<Class<? extends JavaCheck>> javaTestChecks) {
        this.testChecks = this.checkFactory.create(repositoryKey).addAnnotatedChecks(javaTestChecks);
    }

    public Collection<JavaCheck> testCheckClasses() {
        if (this.testChecks == null) {
            return Lists.newArrayList();
        }
        return this.testChecks.all();
    }
}

