/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import javax.annotation.Nullable;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.signature.MethodSignature;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.MethodSignatureScanner;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.indexer.SquidIndex;

public abstract class BytecodeVisitor
implements JavaCheck {
    SquidIndex index;
    JavaResourceLocator javaResourceLocator;

    public void visitClass(AsmClass asmClass) {
    }

    public void visitMethod(AsmMethod asmMethod) {
    }

    public void visitField(AsmField asmField) {
    }

    public void visitEdge(AsmEdge asmEdge) {
    }

    public void leaveClass(AsmClass asmClass) {
    }

    @Nullable
    protected final SourceFile getSourceFile(AsmClass asmClass) {
        String sourceFileKey = this.javaResourceLocator.findSourceFileKeyByClassName(asmClass.getInternalName());
        if (sourceFileKey == null) {
            return null;
        }
        return (SourceFile)this.index.search(sourceFileKey);
    }

    protected final int getMethodLineNumber(AsmMethod asmMethod) {
        MethodSignature methodSignature = MethodSignatureScanner.scan(asmMethod.getGenericKey());
        AsmClass asmClass = asmMethod.getParent();
        Integer result = this.javaResourceLocator.getMethodStartLine(asmClass.getInternalName() + "#" + MethodSignaturePrinter.print(methodSignature));
        if (result != null) {
            return result;
        }
        return -1;
    }

    public final void setSquidIndex(SquidIndex index) {
        this.index = index;
    }

    public void setJavaResourceLocator(JavaResourceLocator javaResourceLocator) {
        this.javaResourceLocator = javaResourceLocator;
    }
}

