/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.sslr.parser.LexerlessGrammar;

public class VisitorsBridge
extends SquidAstVisitor<LexerlessGrammar>
implements CharsetAwareVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(VisitorsBridge.class);
    private final List<JavaFileScanner> scanners;
    private final SonarComponents sonarComponents;
    private SemanticModel semanticModel;
    private List<File> projectClasspath;
    private boolean analyseAccessors;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Arrays.asList(visitor), Lists.newArrayList(), null);
    }

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor, List<File> projectClasspath) {
        this(Arrays.asList(visitor), projectClasspath, null);
    }

    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
        this.sonarComponents = sonarComponents;
        this.projectClasspath = projectClasspath;
    }

    public void setAnalyseAccessors(boolean analyseAccessors) {
        this.analyseAccessors = analyseAccessors;
    }

    @Override
    public void setCharset(Charset charset) {
        for (JavaFileScanner scanner : this.scanners) {
            if (!(scanner instanceof CharsetAwareVisitor)) continue;
            ((CharsetAwareVisitor)((Object)scanner)).setCharset(charset);
        }
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.semanticModel = null;
        if (astNode != null) {
            CompilationUnitTree tree = (CompilationUnitTree)astNode;
            if (this.isNotJavaLangOrSerializable()) {
                try {
                    this.semanticModel = SemanticModel.createFor(tree, this.getProjectClasspath());
                }
                catch (Exception e) {
                    LOG.error("Unable to create symbol table for : " + this.getContext().getFile().getAbsolutePath(), (Throwable)e);
                    return;
                }
                this.createSonarSymbolTable(tree);
            } else {
                SemanticModel.handleMissingTypes(tree);
            }
            DefaultJavaFileScannerContext context = new DefaultJavaFileScannerContext(tree, (SourceFile)this.getContext().peekSourceCode(), this.getContext().getFile(), this.semanticModel, this.analyseAccessors);
            for (JavaFileScanner scanner : this.scanners) {
                scanner.scanFile(context);
            }
            if (this.semanticModel != null) {
                this.semanticModel.done();
            }
        }
    }

    private boolean isNotJavaLangOrSerializable() {
        String[] path = this.getContext().peekSourceCode().getName().split(Pattern.quote(File.separator));
        boolean isJavaLang = path.length > 3 && "java".equals(path[path.length - 3]) && "lang".equals(path[path.length - 2]);
        boolean isJavaLangAnnotation = path.length > 4 && "Annotation.java".equals(path[path.length - 1]) && "java".equals(path[path.length - 4]) && "lang".equals(path[path.length - 3]) && "annotation".equals(path[path.length - 2]);
        boolean isSerializable = path.length > 3 && "Serializable.java".equals(path[path.length - 1]) && "java".equals(path[path.length - 3]) && "io".equals(path[path.length - 2]);
        return !isJavaLang && !isJavaLangAnnotation && !isSerializable;
    }

    private List<File> getProjectClasspath() {
        return this.projectClasspath;
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.getContext().getFile()), this.semanticModel);
            symVisitor.visitCompilationUnit(tree);
        }
    }

    @VisibleForTesting
    public static class DefaultJavaFileScannerContext
    implements JavaFileScannerContext {
        private final CompilationUnitTree tree;
        @VisibleForTesting
        public final SourceFile sourceFile;
        private final SemanticModel semanticModel;
        private final ComplexityVisitor complexityVisitor;
        private final File file;

        public DefaultJavaFileScannerContext(CompilationUnitTree tree, SourceFile sourceFile, File file, SemanticModel semanticModel, boolean analyseAccessors) {
            this.tree = tree;
            this.sourceFile = sourceFile;
            this.file = file;
            this.semanticModel = semanticModel;
            this.complexityVisitor = new ComplexityVisitor(analyseAccessors);
        }

        @Override
        public CompilationUnitTree getTree() {
            return this.tree;
        }

        @Override
        public void addIssue(Tree tree, JavaCheck javaCheck, String message) {
            this.addIssue(((JavaTree)tree).getLine(), javaCheck, message, null);
        }

        @Override
        public void addIssue(Tree tree, JavaCheck check, String message, @Nullable Double cost) {
            this.addIssue(((JavaTree)tree).getLine(), check, message, cost);
        }

        @Override
        public void addIssueOnFile(JavaCheck javaCheck, String message) {
            this.addIssue(-1, javaCheck, message);
        }

        @Override
        public void addIssue(int line, JavaCheck javaCheck, String message) {
            this.addIssue(line, javaCheck, message, null);
        }

        @Override
        public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Double cost) {
            Preconditions.checkNotNull((Object)javaCheck);
            Preconditions.checkNotNull((Object)message);
            CheckMessage checkMessage = new CheckMessage((Object)javaCheck, message, new Object[0]);
            if (line > 0) {
                checkMessage.setLine(line);
            }
            if (cost == null) {
                Annotation linear = AnnotationUtils.getAnnotation((Object)javaCheck, SqaleLinearRemediation.class);
                Annotation linearWithOffset = AnnotationUtils.getAnnotation((Object)javaCheck, SqaleLinearWithOffsetRemediation.class);
                if (linear != null || linearWithOffset != null) {
                    throw new IllegalStateException("A check annotated with a linear sqale function should provide an effort to fix");
                }
            } else {
                checkMessage.setCost(cost.doubleValue());
            }
            this.sourceFile.log(checkMessage);
        }

        @Override
        public void addIssue(Tree tree, CheckMessage checkMessage) {
            checkMessage.setLine(((JavaTree)tree).getLine());
            this.sourceFile.log(checkMessage);
        }

        @Override
        @Nullable
        public Object getSemanticModel() {
            return this.semanticModel;
        }

        @Override
        public String getFileKey() {
            return this.sourceFile.getKey();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public int getComplexity(Tree tree) {
            return this.complexityVisitor.scan(tree);
        }

        @Override
        public int getMethodComplexity(ClassTree enclosingClass, MethodTree methodTree) {
            return this.complexityVisitor.scan(enclosingClass, methodTree);
        }

        @Override
        public void addNoSonarLines(Set<Integer> lines) {
            this.sourceFile.addNoSonarTagLines(lines);
        }
    }
}

